<?php
/**
 * Admin List API Endpoint
 * 
 * Retrieves a list of all admin users
 */

// Initialize the session if not already started
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Include database connection
require_once __DIR__ . '/../../config/db_connect.php';

// Check authentication
if (!isset($_SESSION['admin_id'])) {
    header('Content-Type: application/json');
    echo json_encode([
        'success' => false,
        'message' => 'Authentication required'
    ]);
    exit;
}

try {
    // Get all admin users
    $query = "
        SELECT id, username, name, email, role
        FROM admin_users
        ORDER BY username
    ";
    
    $result = $conn->query($query);
    
    $admins = [];
    while ($row = $result->fetch_assoc()) {
        $admins[] = $row;
    }
    
    // Return admins
    header('Content-Type: application/json');
    echo json_encode([
        'success' => true,
        'data' => $admins
    ]);
} catch (Exception $e) {
    header('Content-Type: application/json');
    echo json_encode([
        'success' => false,
        'message' => 'Error retrieving admin users: ' . $e->getMessage()
    ]);
}
