<?php
/**
 * API endpoint to get assignment statistics
 */

// Include dependencies
require_once '../../config/database.php';
require_once '../../config/auth_enhanced.php';
require_once '../../services/assignment/AssignmentService.php';

use Services\Assignment\AssignmentService;

// Require admin access for viewing assignment statistics
requireAdmin();

// Default response structure
$response = [
    'success' => false,
    'data' => [],
    'message' => 'Error retrieving assignment statistics'
];

// Handle request
if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    try {
        // Create assignment service
        $assignmentService = new AssignmentService();
        
        // Get assignment statistics
        $statistics = $assignmentService->getAssignmentStatistics();
        
        // Set response
        $response = [
            'success' => true,
            'data' => $statistics,
            'message' => 'Assignment statistics retrieved successfully'
        ];
        
        // Return response
        $response = $result;
        
    } catch (Exception $e) {
        $response['message'] = 'Error: ' . $e->getMessage();
    }
} else {
    // Method not allowed
    http_response_code(405);
    $response['message'] = 'Method not allowed. Use GET.';
}

// Send JSON response
header('Content-Type: application/json');
echo json_encode($response);
exit;
