<?php
require_once '../config/database.php';

try {
    $database = new Database();
    $pdo = $database->getConnection();
    
    // Check if KSOCHD001 already exists as an admin
    $stmt = $pdo->prepare("SELECT * FROM admins WHERE kso_id = ? OR username = ?");
    $stmt->execute(['KSOCHD001', 'KSOCHD001']);
    $existing = $stmt->fetch();
    
    if ($existing) {
        echo "Admin with KSOCHD001 already exists. Updating password...\n";
        
        // Update the password
        $password_hash = password_hash('password', PASSWORD_DEFAULT);
        $stmt = $pdo->prepare("UPDATE admins SET password_hash = ?, status = 'active' WHERE kso_id = ? OR username = ?");
        $stmt->execute([$password_hash, 'KSOCHD001', 'KSOCHD001']);
        
        echo "Password updated successfully!\n";
    } else {
        echo "Creating new admin account with KSOCHD001...\n";
        
        // Create new admin account
        $password_hash = password_hash('password', PASSWORD_DEFAULT);
        
        $stmt = $pdo->prepare("
            INSERT INTO admins (
                kso_id, username, email, password_hash, first_name, last_name,
                role, term_from_year, term_to_year, status, created_at, updated_at
            ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, NOW(), NOW())
        ");
        
        $stmt->execute([
            'KSOCHD001',
            'KSOCHD001', 
            'admin@ksochd001.com',
            $password_hash,
            'Admin',
            'User',
            'President',
            2024,
            2025,
            'active'
        ]);
        
        echo "New admin account created successfully!\n";
    }
    
    echo "\nLogin Credentials:\n";
    echo "Username/KSO ID: KSOCHD001\n";
    echo "Password: password\n";
    echo "\nYou can now log in to the dashboard with these credentials.\n";
    
} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
}
?>
