<?php
require_once '../config/database.php';
header('Content-Type: application/json');

try {
    // Check if user is authenticated
    if (!isAuthenticated()) {
        echo json_encode(['success' => false, 'message' => 'Unauthorized access']);
        exit;
    }

    // Refresh session by updating last activity
    $_SESSION['last_activity'] = time();

    echo json_encode([
        'success' => true,
        'message' => 'Session refreshed',
        'timestamp' => time()
    ]);

} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => 'Error: ' . $e->getMessage()]);
}
?>
