<?php
// Debug file to check database connectivity for registration
require_once __DIR__ . '/../../config/database.php';

header('Content-Type: text/plain');

try {
    echo "Checking database connection...\n";
    $database = new Database();
    $pdo = $database->getConnection();
    echo "Database connection successful!\n";
    
    echo "Checking members table...\n";
    $stmt = $pdo->query("SHOW TABLES LIKE 'members'");
    if ($stmt->rowCount() > 0) {
        echo "Members table exists.\n";
    } else {
        echo "Members table does not exist!\n";
    }
    
    echo "Checking kso_id_sequence table...\n";
    $stmt = $pdo->query("SHOW TABLES LIKE 'kso_id_sequence'");
    if ($stmt->rowCount() > 0) {
        echo "KSO ID sequence table exists.\n";
    } else {
        echo "KSO ID sequence table does not exist! Will be created on first registration.\n";
    }
    
    echo "\nDatabase config:\n";
    echo "- Host: " . (defined('DB_HOST') ? DB_HOST : 'Not defined') . "\n";
    echo "- Name: " . (defined('DB_NAME') ? DB_NAME : 'Not defined') . "\n";
    echo "- User: " . (defined('DB_USER') ? DB_USER : 'Not defined') . "\n";
    
} catch (Exception $e) {
    echo "ERROR: " . $e->getMessage() . "\n";
    echo "In file: " . $e->getFile() . " on line " . $e->getLine() . "\n";
    echo "Stack trace:\n" . $e->getTraceAsString() . "\n";
}

echo "\nInclude path: " . get_include_path() . "\n";
echo "Current directory: " . __DIR__ . "\n";
echo "Parent directory: " . dirname(__DIR__) . "\n";
echo "Config file path: " . dirname(__DIR__) . "/config/database.php\n";
echo "File exists: " . (file_exists(dirname(__DIR__) . "/config/database.php") ? "Yes" : "No") . "\n";
?>
