<?php
require_once __DIR__ . '/../config/database.php';
require_once __DIR__ . '/../config/auth_enhanced.php';

header('Content-Type: application/json');

// Ensure only authenticated admin users can delete registrations
if (!isAuthenticated() || !isAdmin()) {
    echo json_encode(['success' => false, 'message' => 'Unauthorized access']);
    exit;
}

// Check if registration ID is provided
if (!isset($_POST['id']) || empty($_POST['id'])) {
    echo json_encode(['success' => false, 'message' => 'Registration ID is required']);
    exit;
}

$registrationId = (int)$_POST['id'];

try {
    $pdo = getDBConnection();
    
    // Check if registration exists
    $stmt = $pdo->prepare("SELECT id FROM event_registrations WHERE id = :id");
    $stmt->execute([':id' => $registrationId]);
    
    if ($stmt->rowCount() == 0) {
        echo json_encode(['success' => false, 'message' => 'Registration not found']);
        exit;
    }
    
    // Delete registration
    $stmt = $pdo->prepare("DELETE FROM event_registrations WHERE id = :id");
    $stmt->execute([':id' => $registrationId]);
    
    echo json_encode([
        'success' => true, 
        'message' => 'Registration deleted successfully'
    ]);
    
} catch (Exception $e) {
    error_log('Error deleting registration: ' . $e->getMessage());
    echo json_encode(['success' => false, 'message' => 'Error: ' . $e->getMessage()]);
}
?>
