<?php
require_once __DIR__ . '/../../config/database.php';
header('Content-Type: application/json');

try {
    $pdo = getDBConnection();

    // Get notification stats
    $stats = [
        'total_notifications' => 0,
        'unread_notifications' => 0,
        'sent_today' => 0,
        'pending_notifications' => 0
    ];

    // Check if notifications table exists
    $stmt = $pdo->query("SHOW TABLES LIKE 'notifications'");
    if ($stmt->rowCount() > 0) {
        // Get total notifications
        $stmt = $pdo->query("SELECT COUNT(*) FROM notifications");
        $stats['total_notifications'] = $stmt->fetchColumn();

        // Get unread notifications
        $stmt = $pdo->query("SELECT COUNT(*) FROM notifications WHERE is_read = 0");
        $stats['unread_notifications'] = $stmt->fetchColumn();

        // Get notifications sent today
        $stmt = $pdo->query("SELECT COUNT(*) FROM notifications WHERE DATE(created_at) = CURDATE()");
        $stats['sent_today'] = $stmt->fetchColumn();

        // Get pending notifications
        $stmt = $pdo->query("SELECT COUNT(*) FROM notifications WHERE status = 'pending'");
        $stats['pending_notifications'] = $stmt->fetchColumn();
    }

    echo json_encode(['success' => true, 'data' => $stats]);

} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => 'Error: ' . $e->getMessage()]);
}
?>
