<?php
require_once __DIR__ . '/../../config/database.php';
header('Content-Type: application/json');

try {
    $pdo = getDBConnection();
    
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        echo json_encode(['success' => false, 'message' => 'Method not allowed']);
        exit;
    }
    
    // Validate required fields
    if (empty($_POST['category_name'])) {
        echo json_encode(['success' => false, 'message' => 'Category name is required']);
        exit;
    }
    
    if (empty($_POST['category_type']) || !in_array($_POST['category_type'], ['credit', 'debit'])) {
        echo json_encode(['success' => false, 'message' => 'Valid category type is required']);
        exit;
    }
    
    // Check if category already exists
    $checkQuery = "SELECT COUNT(*) FROM transaction_categories WHERE LOWER(category_name) = LOWER(?) AND type = ?";
    $checkStmt = $pdo->prepare($checkQuery);
    $checkStmt->execute([trim($_POST['category_name']), $_POST['category_type']]);
    
    if ($checkStmt->fetchColumn() > 0) {
        echo json_encode(['success' => false, 'message' => 'Category with this name already exists for this type']);
        exit;
    }
    
    // Insert new category
    $query = "INSERT INTO transaction_categories (
                category_name,
                description,
                type,
                budget_limit,
                created_at,
                updated_at
              ) VALUES (?, ?, ?, ?, NOW(), NOW())";
    
    $budgetLimit = !empty($_POST['budget_limit']) && is_numeric($_POST['budget_limit']) 
                   ? $_POST['budget_limit'] 
                   : null;
    
    $stmt = $pdo->prepare($query);
    $stmt->execute([
        trim($_POST['category_name']),
        $_POST['description'] ?? null,
        $_POST['category_type'],
        $budgetLimit
    ]);
    
    // Get the inserted ID
    $categoryId = $pdo->lastInsertId();
    
    // Log activity
    $adminId = isset($_SESSION['admin_id']) ? $_SESSION['admin_id'] : null;
    
    $activityQuery = "INSERT INTO activity_logs (
                        action, description, user_id, user_type, ip_address
                    ) VALUES (?, ?, ?, ?, ?)";
    
    $activityStmt = $pdo->prepare($activityQuery);
    $activityStmt->execute([
        'category_added',
        'New ' . $_POST['category_type'] . ' category added: ' . $_POST['category_name'],
        $adminId,
        'admin',
        $_SERVER['REMOTE_ADDR']
    ]);
    
    echo json_encode([
        'success' => true,
        'message' => 'Category added successfully',
        'category_id' => $categoryId,
        'category_name' => $_POST['category_name']
    ]);
    
} catch (PDOException $e) {
    echo json_encode([
        'success' => false,
        'message' => 'Database error: ' . $e->getMessage()
    ]);
}
?>
