<?php
require_once __DIR__ . '/../../config/database.php';
header('Content-Type: application/json');

try {
    $pdo = getDBConnection();
    
    $type = isset($_GET['type']) ? $_GET['type'] : null;
    
    $query = "SELECT * FROM transaction_categories";
    $params = [];
    
    if ($type) {
        $query .= " WHERE type = ?";
        $params[] = $type;
    }
    
    $query .= " ORDER BY category_name ASC";
    
    $stmt = $pdo->prepare($query);
    $stmt->execute($params);
    $categories = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo json_encode([
        'success' => true,
        'categories' => $categories
    ]);
    
} catch (PDOException $e) {
    echo json_encode([
        'success' => false,
        'message' => 'Database error: ' . $e->getMessage()
    ]);
}
?>
