<?php
require_once __DIR__ . '/../../config/database.php';
header('Content-Type: application/json');

try {
    $pdo = getDBConnection();
    
    // Get filter parameters
    $category = isset($_GET['category']) ? $_GET['category'] : null;
    $status = isset($_GET['status']) ? $_GET['status'] : null;
    $startDate = isset($_GET['start_date']) ? $_GET['start_date'] : null;
    $endDate = isset($_GET['end_date']) ? $_GET['end_date'] : null;
    $limit = isset($_GET['limit']) ? (int)$_GET['limit'] : null;
    
    $query = "SELECT 
                t.*,
                c.category_name,
                a.username as approved_by_name
              FROM financial_transactions t
              LEFT JOIN transaction_categories c ON t.transaction_category = c.id
              LEFT JOIN admins a ON t.approved_by = a.id
              WHERE t.transaction_type = 'debit'";
    
    $params = [];
    
    // Apply filters
    if ($category) {
        $query .= " AND t.transaction_category = ?";
        $params[] = $category;
    }
    
    if ($status) {
        $query .= " AND t.status = ?";
        $params[] = $status;
    }
    
    if ($startDate) {
        $query .= " AND t.transaction_date >= ?";
        $params[] = $startDate;
    }
    
    if ($endDate) {
        $query .= " AND t.transaction_date <= ?";
        $params[] = $endDate;
    }
    
    $query .= " ORDER BY t.transaction_date DESC, t.id DESC";
    
    // Apply limit if specified
    if ($limit) {
        $query .= " LIMIT ?";
        $params[] = $limit;
    }
    
    $stmt = $pdo->prepare($query);
    $stmt->execute($params);
    $expenses = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    // Format the response
    foreach ($expenses as &$expense) {
        // Format dates
        $expense['transaction_date'] = date('Y-m-d', strtotime($expense['transaction_date']));
        $expense['created_at'] = date('Y-m-d H:i:s', strtotime($expense['created_at']));
        
        // Format amount
        $expense['amount'] = (float)$expense['amount'];
    }
    
    echo json_encode([
        'success' => true,
        'expenses' => $expenses,
        'total_count' => count($expenses)
    ]);
    
} catch (PDOException $e) {
    echo json_encode([
        'success' => false,
        'message' => 'Database error: ' . $e->getMessage()
    ]);
}
?>
