<?php
require_once __DIR__ . '/../../config/database.php';
header('Content-Type: application/json');

try {
    $pdo = getDBConnection();
    
    $start_date = $_GET['start_date'] ?? date('Y-m-01');
    $end_date = $_GET['end_date'] ?? date('Y-m-t');
    
    // Get financial summary by category
    $stmt = $pdo->prepare("
        SELECT 
            COALESCE(tc.name, 'Uncategorized') as category,
            ft.transaction_type,
            COUNT(*) as count,
            SUM(ft.amount) as amount
        FROM financial_transactions ft
        LEFT JOIN transaction_categories tc ON ft.category_id = tc.id
        WHERE ft.transaction_date BETWEEN ? AND ?
        GROUP BY ft.category_id, ft.transaction_type
        ORDER BY ft.transaction_type DESC, amount DESC
    ");
    $stmt->execute([$start_date, $end_date]);
    $summary_data = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    // Format category names to indicate credit/debit
    $formatted_data = [];
    foreach ($summary_data as $row) {
        $category = $row['category'];
        $type = $row['transaction_type'];
        
        // Format amount with proper currency and sign
        $amount = floatval($row['amount']);
        
        // Append the transaction type in parentheses
        $formatted_data[] = [
            'category' => $category . ' (' . ucfirst($type) . ')',
            'amount' => $amount,
            'count' => $row['count'],
            'transaction_type' => $type
        ];
    }
    
    echo json_encode([
        'success' => true,
        'data' => $formatted_data
    ]);
        GROUP BY t.transaction_category, c.category_name
        ORDER BY total_amount DESC
    ]);
    
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'error' => 'Error fetching financial summary: ' . $e->getMessage()
    ]);
}
?>
