<?php
require_once __DIR__ . '/../../config/database.php';
header('Content-Type: application/json');

try {
    $pdo = getDBConnection();
    
    if (!isset($_GET['id']) || !is_numeric($_GET['id'])) {
        echo json_encode(['success' => false, 'message' => 'Invalid transaction ID']);
        exit;
    }
    
    $query = "SELECT 
                t.*,
                c.category_name,
                a.username as approved_by_name,
                CONCAT(a.first_name, ' ', a.last_name) as approved_by_full_name
              FROM financial_transactions t
              LEFT JOIN transaction_categories c ON t.transaction_category = c.id
              LEFT JOIN admins a ON t.approved_by = a.id
              WHERE t.id = ? AND t.transaction_type = 'debit'";
    
    $stmt = $pdo->prepare($query);
    $stmt->execute([(int)$_GET['id']]);
    $expense = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$expense) {
        echo json_encode(['success' => false, 'message' => 'Expense transaction not found']);
        exit;
    }
    
    // Format dates
    $expense['transaction_date'] = date('Y-m-d', strtotime($expense['transaction_date']));
    $expense['created_at'] = date('Y-m-d H:i:s', strtotime($expense['created_at']));
    
    // Format amount
    $expense['amount'] = (float)$expense['amount'];
    
    echo json_encode([
        'success' => true,
        'expense' => $expense
    ]);
    
} catch (PDOException $e) {
    echo json_encode([
        'success' => false,
        'message' => 'Database error: ' . $e->getMessage()
    ]);
}
?>
