<?php
require_once __DIR__ . '/../../config/database.php';
header('Content-Type: application/json');

try {
    $pdo = getDBConnection();
    
    if (!isset($_GET['id']) || !is_numeric($_GET['id'])) {
        echo json_encode(['success' => false, 'message' => 'Invalid transaction ID']);
        exit;
    }
    
    $query = "SELECT 
                t.*,
                c.category_name
              FROM financial_transactions t
              LEFT JOIN transaction_categories c ON t.transaction_category = c.id
              WHERE t.id = ?";
    
    $stmt = $pdo->prepare($query);
    $stmt->execute([(int)$_GET['id']]);
    $transaction = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$transaction) {
        echo json_encode(['success' => false, 'message' => 'Transaction not found']);
        exit;
    }
    
    echo json_encode([
        'success' => true,
        'transaction' => $transaction
    ]);
    
} catch (PDOException $e) {
    echo json_encode([
        'success' => false,
        'message' => 'Database error: ' . $e->getMessage()
    ]);
}
?>
