<?php
require_once __DIR__ . '/../../config/database.php';
header('Content-Type: application/json');

try {
    $pdo = getDBConnection();
    
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        echo json_encode(['success' => false, 'message' => 'Method not allowed']);
        exit;
    }
    
    // Validate required fields
    if (empty($_POST['category_id']) || !is_numeric($_POST['category_id'])) {
        echo json_encode(['success' => false, 'message' => 'Invalid category ID']);
        exit;
    }
    
    if (empty($_POST['category_name'])) {
        echo json_encode(['success' => false, 'message' => 'Category name is required']);
        exit;
    }
    
    if (empty($_POST['category_type']) || !in_array($_POST['category_type'], ['credit', 'debit'])) {
        echo json_encode(['success' => false, 'message' => 'Valid category type is required']);
        exit;
    }
    
    // Check if category exists
    $checkQuery = "SELECT COUNT(*) FROM transaction_categories WHERE id = ?";
    $checkStmt = $pdo->prepare($checkQuery);
    $checkStmt->execute([(int)$_POST['category_id']]);
    
    if ($checkStmt->fetchColumn() == 0) {
        echo json_encode(['success' => false, 'message' => 'Category not found']);
        exit;
    }
    
    // Check if name already exists for another category of the same type
    $nameCheckQuery = "SELECT COUNT(*) FROM transaction_categories WHERE LOWER(category_name) = LOWER(?) AND type = ? AND id != ?";
    $nameCheckStmt = $pdo->prepare($nameCheckQuery);
    $nameCheckStmt->execute([
        trim($_POST['category_name']), 
        $_POST['category_type'],
        (int)$_POST['category_id']
    ]);
    
    if ($nameCheckStmt->fetchColumn() > 0) {
        echo json_encode(['success' => false, 'message' => 'Another category with this name already exists for this type']);
        exit;
    }
    
    // Update category
    $query = "UPDATE transaction_categories SET
                category_name = ?,
                description = ?,
                budget_limit = ?,
                updated_at = NOW()
              WHERE id = ?";
    
    $budgetLimit = !empty($_POST['budget_limit']) && is_numeric($_POST['budget_limit']) 
                   ? $_POST['budget_limit'] 
                   : null;
    
    $stmt = $pdo->prepare($query);
    $stmt->execute([
        trim($_POST['category_name']),
        $_POST['description'] ?? null,
        $budgetLimit,
        (int)$_POST['category_id']
    ]);
    
    // Log activity
    $adminId = isset($_SESSION['admin_id']) ? $_SESSION['admin_id'] : null;
    
    $activityQuery = "INSERT INTO activity_logs (
                        action, description, user_id, user_type, ip_address
                    ) VALUES (?, ?, ?, ?, ?)";
    
    $activityStmt = $pdo->prepare($activityQuery);
    $activityStmt->execute([
        'category_updated',
        $_POST['category_type'] . ' category updated: ' . $_POST['category_name'],
        $adminId,
        'admin',
        $_SERVER['REMOTE_ADDR']
    ]);
    
    echo json_encode([
        'success' => true,
        'message' => 'Category updated successfully'
    ]);
    
} catch (PDOException $e) {
    echo json_encode([
        'success' => false,
        'message' => 'Database error: ' . $e->getMessage()
    ]);
}
?>
