<?php
require_once '../../config/database.php';
require_once '../../config/auth_enhanced.php';

header('Content-Type: application/json');

// Check authentication
if (!isAuthenticated()) {
    echo json_encode(['success' => false, 'message' => 'Unauthorized access']);
    exit;
}

try {
    $database = new Database();
    $conn = $database->getConnection();
    
    // Query to get unique session years
    $query = "SELECT DISTINCT session_from_year FROM members WHERE session_from_year IS NOT NULL ORDER BY session_from_year DESC";
    
    $stmt = $conn->prepare($query);
    $stmt->execute();
    
    $results = $stmt->fetchAll(PDO::FETCH_COLUMN);
    
    // If no session years found, provide default values
    if (empty($results)) {
        $currentYear = date('Y');
        $results = [$currentYear, $currentYear - 1, $currentYear - 2];
    }
    
    echo json_encode([
        'success' => true,
        'data' => $results,
        'message' => 'Session years fetched successfully'
    ]);
    
} catch (PDOException $e) {
    echo json_encode([
        'success' => false,
        'message' => 'Database error: ' . $e->getMessage()
    ]);
}
