<?php
require_once '../config/database.php';
require_once '../config/auth_enhanced.php';

if (!isLoggedIn()) {
    http_response_code(401);
    echo json_encode(['error' => 'Unauthorized access']);
    exit;
}

header('Content-Type: application/json');

try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    $start_date = $_GET['start_date'] ?? date('Y-m-01');
    $end_date = $_GET['end_date'] ?? date('Y-m-t');
    $report_type = $_GET['report_type'] ?? 'all';
    
    // Initialize summary data
    $data = [
        'total_members' => 0,
        'new_members' => 0,
        'active_members' => 0,
        'total_events' => 0,
        'events_in_period' => 0,
        'total_revenue' => 0,
        'pending_payments' => 0
    ];
    
    // Get member stats if membership report is requested
    if ($report_type === 'all' || $report_type === 'membership') {
        $stmt = $pdo->prepare("
            SELECT 
                COUNT(*) as total_members,
                COUNT(CASE WHEN created_at BETWEEN ? AND ? THEN 1 END) as new_members,
                COUNT(CASE WHEN status = 'approved' THEN 1 END) as active_members,
                COUNT(CASE WHEN status = 'pending' THEN 1 END) as pending_members
            FROM members
        ");
        $stmt->execute([$start_date, $end_date]);
        $memberStats = $stmt->fetch(PDO::FETCH_ASSOC);
        
        $data['total_members'] = $memberStats['total_members'];
        $data['new_members'] = $memberStats['new_members'];
        $data['active_members'] = $memberStats['active_members'];
    }
    
    // Get event stats if event report is requested
    if ($report_type === 'all' || $report_type === 'events') {
        $stmt = $pdo->prepare("
            SELECT 
                COUNT(*) as total_events,
                COUNT(CASE WHEN date BETWEEN ? AND ? THEN 1 END) as events_in_period
            FROM events
        ");
        $stmt->execute([$start_date, $end_date]);
        $eventStats = $stmt->fetch(PDO::FETCH_ASSOC);
        
        $data['total_events'] = $eventStats['events_in_period'];
    }
    
    // Get financial stats if financial report is requested
    if ($report_type === 'all' || $report_type === 'financial') {
        // Get financial summary using the debit/credit model
        $stmt = $pdo->prepare("
            SELECT 
                SUM(CASE WHEN transaction_type = 'credit' THEN amount ELSE 0 END) as total_credit,
                SUM(CASE WHEN transaction_type = 'debit' THEN amount ELSE 0 END) as total_debit,
                SUM(CASE WHEN status = 'pending' THEN amount ELSE 0 END) as pending_amount
            FROM financial_transactions
            WHERE transaction_date BETWEEN ? AND ?
        ");
        $stmt->execute([$start_date, $end_date]);
        $financialStats = $stmt->fetch(PDO::FETCH_ASSOC);
        
        $data['total_revenue'] = ($financialStats['total_credit'] ?? 0) - ($financialStats['total_debit'] ?? 0);
        $data['pending_payments'] = $financialStats['pending_amount'] ?? 0;
    }
    
    echo json_encode([
        'success' => true,
        'data' => $data
    ]);
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'error' => 'Error fetching report summary: ' . $e->getMessage()
    ]);
}
?>
    ");
    $stmt->execute([$start_date, $end_date, $start_date, $end_date, $start_date, $end_date]);
    $financialStats = $stmt->fetch(PDO::FETCH_ASSOC);
    
    // Event registrations summary
    $stmt = $pdo->prepare("
        SELECT 
            COUNT(*) as total_registrations,
            COUNT(CASE WHEN er.created_at BETWEEN ? AND ? THEN 1 END) as new_registrations,
            COALESCE(SUM(CASE WHEN er.payment_status = 'paid' AND er.created_at BETWEEN ? AND ? THEN er.amount_paid ELSE 0 END), 0) as registration_revenue
        FROM event_registrations er
    ");
    $stmt->execute([$start_date, $end_date, $start_date, $end_date]);
    $registrationStats = $stmt->fetch(PDO::FETCH_ASSOC);
    
    $netIncome = $financialStats['total_income'] - $financialStats['total_expenses'];
    
    echo json_encode([
        'period' => [
            'start_date' => $start_date,
            'end_date' => $end_date
        ],
        'members' => $memberStats,
        'events' => $eventStats,
        'finances' => array_merge($financialStats, ['net_income' => $netIncome]),
        'registrations' => $registrationStats
    ]);
    
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['error' => 'Database error: ' . $e->getMessage()]);
}
?>
