<?php
require_once __DIR__ . '/../config/database.php';
header('Content-Type: application/json');

try {
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        echo json_encode(['success' => false, 'message' => 'Method not allowed']);
        exit;
    }
    
    $pdo = getDBConnection();
    
    // Get the current year
    $currentYear = date('Y');
    
    // Start transaction
    $pdo->beginTransaction();
    
    // Process Individual membership fees
    $individual1Year = isset($_POST['individual_1_year']) ? floatval($_POST['individual_1_year']) : 1000.00;
    $individual2Years = isset($_POST['individual_2_years']) ? floatval($_POST['individual_2_years']) : 1800.00;
    $individual3Years = isset($_POST['individual_3_years']) ? floatval($_POST['individual_3_years']) : 2500.00;
    $individual5Years = isset($_POST['individual_5_years']) ? floatval($_POST['individual_5_years']) : 4000.00;
    
    // Process Family membership fees
    $family1Year = isset($_POST['family_1_year']) ? floatval($_POST['family_1_year']) : 1500.00;
    $family2Years = isset($_POST['family_2_years']) ? floatval($_POST['family_2_years']) : 2700.00;
    $family3Years = isset($_POST['family_3_years']) ? floatval($_POST['family_3_years']) : 3800.00;
    $family5Years = isset($_POST['family_5_years']) ? floatval($_POST['family_5_years']) : 6000.00;
    
    // Process Student membership fees
    $student1Year = isset($_POST['student_1_year']) ? floatval($_POST['student_1_year']) : 500.00;
    $student2Years = isset($_POST['student_2_years']) ? floatval($_POST['student_2_years']) : 900.00;
    
    // Process Senior Citizen membership fees
    $senior1Year = isset($_POST['senior_1_year']) ? floatval($_POST['senior_1_year']) : 800.00;
    $seniorLifetime = isset($_POST['senior_lifetime']) ? floatval($_POST['senior_lifetime']) : 5000.00;
    
    // Additional fees
    $lateFee = isset($_POST['late_fee']) ? floatval($_POST['late_fee']) : 200.00;
    $processingFee = isset($_POST['processing_fee']) ? floatval($_POST['processing_fee']) : 50.00;
    
    // Update or insert fee settings for Individual and Family (most commonly used)
    $stmt = $pdo->prepare("
        INSERT INTO membership_fee_settings 
        (membership_type, session_year, fee_amount, late_fee_amount, description, is_active) 
        VALUES (?, ?, ?, ?, ?, 1)
        ON DUPLICATE KEY UPDATE 
        fee_amount = VALUES(fee_amount),
        late_fee_amount = VALUES(late_fee_amount),
        description = VALUES(description),
        is_active = 1,
        updated_at = NOW()
    ");
    
    // Update Individual 1 year fee
    $stmt->execute([
        'Individual', 
        $currentYear, 
        $individual1Year, 
        $lateFee, 
        'Annual individual membership fee for ' . $currentYear
    ]);
    
    // Update Family 1 year fee
    $stmt->execute([
        'Family', 
        $currentYear, 
        $family1Year, 
        $lateFee, 
        'Annual family membership fee for ' . $currentYear
    ]);
    
    // Save additional fees in settings table
    $settingsStmt = $pdo->prepare("
        INSERT INTO settings (setting_key, setting_value, description) 
        VALUES (?, ?, ?) 
        ON DUPLICATE KEY UPDATE 
        setting_value = VALUES(setting_value),
        updated_at = NOW()
    ");
    
    // Store multi-year fees and other fee types in settings
    $settingsToUpdate = [
        'individual_2_years_fee' => $individual2Years,
        'individual_3_years_fee' => $individual3Years,
        'individual_5_years_fee' => $individual5Years,
        'family_2_years_fee' => $family2Years,
        'family_3_years_fee' => $family3Years,
        'family_5_years_fee' => $family5Years,
        'student_1_year_fee' => $student1Year,
        'student_2_years_fee' => $student2Years,
        'senior_1_year_fee' => $senior1Year,
        'senior_lifetime_fee' => $seniorLifetime,
        'processing_fee' => $processingFee
    ];
    
    foreach ($settingsToUpdate as $key => $value) {
        $settingsStmt->execute([$key, $value, 'Membership fee setting']);
    }
    
    $pdo->commit();
    
    echo json_encode([
        'success' => true,
        'message' => 'Fee structure updated successfully'
    ]);
    
} catch (PDOException $e) {
    if ($pdo->inTransaction()) {
        $pdo->rollBack();
    }
    
    echo json_encode([
        'success' => false,
        'message' => 'Database error: ' . $e->getMessage()
    ]);
}
?>
