-- Finance Tables for KSO Chandigarh
-- Created: July 17, 2025

-- Table for transaction categories
CREATE TABLE IF NOT EXISTS transaction_categories (
    id INT AUTO_INCREMENT PRIMARY KEY,
    category_name VARCHAR(100) NOT NULL,
    description TEXT,
    type ENUM('credit', 'debit') NOT NULL,
    budget_limit DECIMAL(10, 2) DEFAULT NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Table for financial transactions
CREATE TABLE IF NOT EXISTS financial_transactions (
    id INT AUTO_INCREMENT PRIMARY KEY,
    transaction_title VARCHAR(255) NOT NULL,
    transaction_category INT NOT NULL,
    amount DECIMAL(10, 2) NOT NULL,
    transaction_date DATE NOT NULL,
    transaction_type ENUM('credit', 'debit') NOT NULL,
    receipt_number VARCHAR(50) DEFAULT NULL,
    receipt_file VARCHAR(255) DEFAULT NULL,
    description TEXT,
    status ENUM('pending', 'approved', 'rejected', 'paid') NOT NULL DEFAULT 'pending',
    payment_method VARCHAR(50) NOT NULL,
    created_by INT DEFAULT NULL,
    approved_by INT DEFAULT NULL,
    notes TEXT,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    FOREIGN KEY (transaction_category) REFERENCES transaction_categories(id),
    FOREIGN KEY (created_by) REFERENCES admins(id),
    FOREIGN KEY (approved_by) REFERENCES admins(id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Insert default categories
INSERT INTO transaction_categories (category_name, description, type, created_at, updated_at) VALUES
('Membership Fees', 'Annual membership fees collected from members', 'credit', NOW(), NOW()),
('Event Registration', 'Fees collected for event registrations', 'credit', NOW(), NOW()),
('Donations', 'Donations received from members and non-members', 'credit', NOW(), NOW()),
('Sponsorships', 'Sponsorship amounts received for events and activities', 'credit', NOW(), NOW()),
('Office Supplies', 'Expenses for office supplies and stationery', 'debit', NOW(), NOW()),
('Event Expenses', 'Expenses related to organizing events', 'debit', NOW(), NOW()),
('Utilities', 'Expenses for electricity, water, internet, etc.', 'debit', NOW(), NOW()),
('Rent', 'Office or venue rental expenses', 'debit', NOW(), NOW()),
('Marketing', 'Expenses for advertising and promotional activities', 'debit', NOW(), NOW()),
('Miscellaneous', 'Other miscellaneous expenses', 'debit', NOW(), NOW());
