<?php
require_once 'config/database.php';
requireAdmin();

require_once 'templates/header.php';
require_once 'templates/navbar.php';
require_once 'templates/sidebar.php';
?>

<!-- Content Wrapper -->
<div class="content-wrapper">
    <!-- Content Header -->
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">Reports & Analytics</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="index.php">Home</a></li>
                        <li class="breadcrumb-item active">Reports</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>

    <!-- Main content -->
    <section class="content">
        <div class="container-fluid">
            <!-- Filter Section -->
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">Report Filters</h3>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label>Date Range</label>
                                        <select id="dateRange" class="form-control">
                                            <option value="today">Today</option>
                                            <option value="yesterday">Yesterday</option>
                                            <option value="week">This Week</option>
                                            <option value="last_week">Last Week</option>
                                            <option value="month" selected>This Month</option>
                                            <option value="last_month">Last Month</option>
                                            <option value="quarter">This Quarter</option>
                                            <option value="last_quarter">Last Quarter</option>
                                            <option value="year">This Year</option>
                                            <option value="last_year">Last Year</option>
                                            <option value="financial_year">Financial Year</option>
                                            <option value="custom">Custom Range</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <div class="form-group">
                                        <label>Start Date</label>
                                        <input type="date" id="startDate" class="form-control">
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <div class="form-group">
                                        <label>End Date</label>
                                        <input type="date" id="endDate" class="form-control">
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <div class="form-group">
                                        <label>Report Type</label>
                                        <select id="reportType" class="form-control">
                                            <option value="all" selected>All Reports</option>
                                            <option value="financial">Financial Only</option>
                                            <option value="membership">Membership Only</option>
                                            <option value="events">Events Only</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label>&nbsp;</label>
                                        <button type="button" id="generateReports" class="btn btn-primary btn-block">
                                            <i class="fas fa-chart-line"></i> Generate Reports
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Summary Cards -->
            <div class="row" id="summaryCards">
                <div class="col-lg-3 col-6">
                    <div class="small-box bg-info">
                        <div class="inner">
                            <h3 id="totalMembers">0</h3>
                            <p>Total Members</p>
                        </div>
                        <div class="icon">
                            <i class="fas fa-users"></i>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3 col-6">
                    <div class="small-box bg-success">
                        <div class="inner">
                            <h3 id="totalRevenue">₹0</h3>
                            <p>Total Revenue</p>
                        </div>
                        <div class="icon">
                            <i class="fas fa-rupee-sign"></i>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3 col-6">
                    <div class="small-box bg-warning">
                        <div class="inner">
                            <h3 id="totalEvents">0</h3>
                            <p>Total Events</p>
                        </div>
                        <div class="icon">
                            <i class="fas fa-calendar"></i>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3 col-6">
                    <div class="small-box bg-danger">
                        <div class="inner">
                            <h3 id="pendingPayments">0</h3>
                            <p>Pending Payments</p>
                        </div>
                        <div class="icon">
                            <i class="fas fa-exclamation-circle"></i>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Charts Section -->
            <div class="row">
                <!-- Revenue Chart -->
                <div class="col-md-6 financial-report">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">Revenue Trend</h3>
                            <div class="card-tools">
                                <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                    <i class="fas fa-minus"></i>
                                </button>
                            </div>
                        </div>
                        <div class="card-body">
                            <canvas id="revenueChart" height="200"></canvas>
                        </div>
                    </div>
                </div>

                <!-- Membership Chart -->
                <div class="col-md-6 membership-report">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">Membership Growth</h3>
                            <div class="card-tools">
                                <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                    <i class="fas fa-minus"></i>
                                </button>
                            </div>
                        </div>
                        <div class="card-body">
                            <canvas id="membershipChart" height="200"></canvas>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Event Attendance Chart -->
            <div class="row">
                <div class="col-md-8">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">Event Attendance</h3>
                        </div>
                        <div class="card-body">
                            <canvas id="eventChart" height="150"></canvas>
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">Payment Methods</h3>
                        </div>
                        <div class="card-body">
                            <canvas id="paymentChart" height="200"></canvas>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Detailed Reports Tables -->
            <div class="row">
                <!-- Financial Report -->
                <div class="col-md-6 financial-report">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">Financial Summary</h3>
                            <div class="card-tools">
                                <button type="button" class="btn btn-success btn-sm" onclick="exportReport('financial')">
                                    <i class="fas fa-download"></i> Export
                                </button>
                            </div>
                        </div>
                        <div class="card-body table-responsive p-0">
                            <table class="table table-hover text-nowrap">
                                <thead>
                                    <tr>
                                        <th>Category</th>
                                        <th>Amount</th>
                                        <th>Count</th>
                                    </tr>
                                </thead>
                                <tbody id="financialSummary">
                                    <!-- Data will be populated via AJAX -->
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

                <!-- Member Report -->
                <div class="col-md-6 membership-report">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">Member Summary</h3>
                            <div class="card-tools">
                                <button type="button" class="btn btn-success btn-sm" onclick="exportReport('members')">
                                    <i class="fas fa-download"></i> Export
                                </button>
                            </div>
                        </div>
                        <div class="card-body table-responsive p-0">
                            <table class="table table-hover text-nowrap">
                                <thead>
                                    <tr>
                                        <th>Status</th>
                                        <th>Count</th>
                                        <th>Percentage</th>
                                    </tr>
                                </thead>
                                <tbody id="memberSummary">
                                    <!-- Data will be populated via AJAX -->
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Detailed Financial Report -->
            <div class="row">
                <div class="col-12 financial-report">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">Detailed Financial Report</h3>
                            <div class="card-tools">
                                <button type="button" class="btn btn-success btn-sm" onclick="exportReport('detailed_finance')">
                                    <i class="fas fa-download"></i> Export
                                </button>
                            </div>
                        </div>
                        <div class="card-body table-responsive p-0">
                            <table id="detailedFinanceTable" class="table table-bordered table-striped">
                                <thead>
                                    <tr>
                                        <th>ID</th>
                                        <th>Date</th>
                                        <th>Title</th>
                                        <th>Category</th>
                                        <th>Type</th>
                                        <th>Amount</th>
                                        <th>Status</th>
                                        <th>Payment Method</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <!-- Data will be populated via AJAX -->
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <th colspan="5" class="text-right">Total:</th>
                                        <th id="totalAmount"></th>
                                        <th colspan="2"></th>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Event Performance Report -->
            <div class="row">
                <div class="col-12 events-report">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">Event Performance Report</h3>
                            <div class="card-tools">
                                <button type="button" class="btn btn-success btn-sm" onclick="exportReport('events')">
                                    <i class="fas fa-download"></i> Export
                                </button>
                            </div>
                        </div>
                        <div class="card-body">
                            <table id="eventReportTable" class="table table-bordered table-striped">
                                <thead>
                                    <tr>
                                        <th>Event Name</th>
                                        <th>Date</th>
                                        <th>Registrations</th>
                                        <th>Attendance</th>
                                        <th>Revenue</th>
                                        <th>Status</th>
                                        <th>Performance</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <!-- Data will be populated via AJAX -->
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<!-- Export Modal -->
<div class="modal fade" id="exportModal" tabindex="-1" role="dialog" aria-labelledby="exportModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exportModalLabel">Export Report</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form id="exportForm">
                    <input type="hidden" id="exportReportType" name="exportReportType">
                    <input type="hidden" id="exportStartDate" name="exportStartDate">
                    <input type="hidden" id="exportEndDate" name="exportEndDate">
                    
                    <div class="form-group">
                        <label for="exportFormat">Export Format</label>
                        <select class="form-control" id="exportFormat" name="exportFormat">
                            <option value="pdf">PDF</option>
                            <option value="csv">CSV</option>
                            <option value="excel">Excel</option>
                            <option value="json">JSON</option>
                        </select>
                    </div>
                    
                    <div class="form-group">
                        <label>Report Options</label>
                        <div class="custom-control custom-checkbox">
                            <input class="custom-control-input" type="checkbox" id="includeCharts" name="includeCharts" value="1" checked>
                            <label for="includeCharts" class="custom-control-label">Include Charts</label>
                        </div>
                        <div class="custom-control custom-checkbox">
                            <input class="custom-control-input" type="checkbox" id="includeSummary" name="includeSummary" value="1" checked>
                            <label for="includeSummary" class="custom-control-label">Include Summary</label>
                        </div>
                        <div class="custom-control custom-checkbox">
                            <input class="custom-control-input" type="checkbox" id="includeDetails" name="includeDetails" value="1" checked>
                            <label for="includeDetails" class="custom-control-label">Include Details</label>
                        </div>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                <button type="button" class="btn btn-primary" onclick="processExport()">Export</button>
            </div>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
let revenueChart, membershipChart, eventChart, paymentChart;

$(document).ready(function() {
    // Set default date range
    const today = new Date();
    const firstDay = new Date(today.getFullYear(), today.getMonth(), 1);
    $('#startDate').val(firstDay.toISOString().split('T')[0]);
    $('#endDate').val(today.toISOString().split('T')[0]);
    
    // Initialize charts
    initializeCharts();
    
    // Load initial data
    generateReports();
    
    // Event listeners
    $('#generateReports').click(generateReports);
    $('#dateRange').change(function() {
        if ($(this).val() !== 'custom') {
            setDateRange($(this).val());
            generateReports();
        }
    });
    
    // Initialize event report table
    $('#eventReportTable').DataTable({
        "processing": true,
        "serverSide": false,
        "ajax": {
            "url": "api/reports/fetch_event_reports.php",
            "data": function(d) {
                d.start_date = $('#startDate').val();
                d.end_date = $('#endDate').val();
            }
        },
        "columns": [
            { "data": "event_name" },
            { "data": "event_date", "render": function(data) {
                return new Date(data).toLocaleDateString();
            }},
            { "data": "registrations" },
            { "data": "attendance" },
            { "data": "revenue", "render": function(data) {
                return '₹' + parseFloat(data).toLocaleString();
            }},
            { "data": "status" },
            { "data": null, "render": function(data) {
                const performance = (data.attendance / data.registrations * 100).toFixed(1);
                let badgeClass = 'secondary';
                if (performance >= 80) badgeClass = 'success';
                else if (performance >= 60) badgeClass = 'warning';
                else badgeClass = 'danger';
                return `<span class="badge badge-${badgeClass}">${performance}%</span>`;
            }}
        ]
    });
    
    // Initialize detailed finance table
    const financeTable = $('#detailedFinanceTable').DataTable({
        "processing": true,
        "serverSide": false,
        "ajax": {
            "url": "api/finance/fetch_transactions.php",
            "data": function(d) {
                d.start_date = $('#startDate').val();
                d.end_date = $('#endDate').val();
            }
        },
        "columns": [
            { "data": "id" },
            { "data": "transaction_date_formatted" },
            { "data": "transaction_title" },
            { "data": "category_name" },
            { 
                "data": "transaction_type", 
                "render": function(data) {
                    if (data === 'credit') {
                        return '<span class="badge badge-success"><i class="fas fa-arrow-down"></i> Credit</span>';
                    } else {
                        return '<span class="badge badge-danger"><i class="fas fa-arrow-up"></i> Debit</span>';
                    }
                }
            },
            { 
                "data": "amount", 
                "render": function(data, type, row) {
                    const amount = parseFloat(data);
                    let displayAmount, textColor;
                    
                    if (row.transaction_type === 'debit') {
                        // Negative sign for expenses (debit)
                        displayAmount = `-₹${amount.toFixed(2)}`;
                        textColor = 'text-danger';
                    } else {
                        // Positive sign for income (credit)
                        displayAmount = `+₹${amount.toFixed(2)}`;
                        textColor = 'text-success';
                    }
                    
                    return `<span class="${textColor} font-weight-bold">${displayAmount}</span>`;
                }
            },
            { 
                "data": "status", 
                "render": function(data, type, row) {
                    return `<span class="badge badge-${row.status_badge}">${data}</span>`;
                }
            },
            { "data": "payment_method" }
        ],
        "order": [[1, "desc"]], // Order by date descending
        "responsive": true,
        "lengthChange": true,
        "autoWidth": false,
        "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"],
        "footerCallback": function(row, data, start, end, display) {
            const api = this.api();
            
            // Calculate totals
            const creditTotal = api.column(5).data().reduce(function(a, b) {
                const amount = parseFloat(b);
                const row = api.row(api.column(5).nodes().indexOf(b)).data();
                return a + (row.transaction_type === 'credit' ? amount : 0);
            }, 0);
            
            const debitTotal = api.column(5).data().reduce(function(a, b) {
                const amount = parseFloat(b);
                const row = api.row(api.column(5).nodes().indexOf(b)).data();
                return a + (row.transaction_type === 'debit' ? amount : 0);
            }, 0);
            
            const netTotal = creditTotal - debitTotal;
            
            // Format the net total with color and sign
            let totalDisplay, totalClass;
            if (netTotal >= 0) {
                totalDisplay = `+₹${netTotal.toLocaleString(undefined, {minimumFractionDigits: 2, maximumFractionDigits: 2})}`;
                totalClass = 'text-success';
            } else {
                totalDisplay = `-₹${Math.abs(netTotal).toLocaleString(undefined, {minimumFractionDigits: 2, maximumFractionDigits: 2})}`;
                totalClass = 'text-danger';
            }
            
            // Display in footer
            $('#totalAmount').html(`<span class="${totalClass} font-weight-bold">${totalDisplay}</span>`);
        }
    }).buttons().container().appendTo('#detailedFinanceTable_wrapper .col-md-6:eq(0)');
});

function setDateRange(range) {
    const today = new Date();
    let startDate, endDate = today;
    
    switch(range) {
        case 'today':
            startDate = today;
            break;
        case 'yesterday':
            startDate = new Date(today);
            startDate.setDate(today.getDate() - 1);
            endDate = new Date(startDate);
            break;
        case 'week':
            // Start from current week's Sunday (or Monday based on preference)
            const dayOfWeek = today.getDay(); // 0 is Sunday, 1 is Monday, etc.
            const diffToStartOfWeek = dayOfWeek === 0 ? 6 : dayOfWeek - 1; // Adjust for starting week on Monday
            startDate = new Date(today);
            startDate.setDate(today.getDate() - diffToStartOfWeek);
            break;
        case 'last_week':
            // Last week (previous Monday to Sunday)
            const lastWeekEnd = new Date(today);
            const dayOfLastWeek = today.getDay() || 7; // Convert Sunday from 0 to 7
            lastWeekEnd.setDate(today.getDate() - dayOfLastWeek);
            endDate = new Date(lastWeekEnd);
            startDate = new Date(lastWeekEnd);
            startDate.setDate(lastWeekEnd.getDate() - 6);
            break;
        case 'month':
            startDate = new Date(today.getFullYear(), today.getMonth(), 1);
            break;
        case 'last_month':
            endDate = new Date(today.getFullYear(), today.getMonth(), 0);
            startDate = new Date(today.getFullYear(), today.getMonth() - 1, 1);
            break;
        case 'quarter':
            const quarter = Math.floor(today.getMonth() / 3);
            startDate = new Date(today.getFullYear(), quarter * 3, 1);
            break;
        case 'last_quarter':
            const currentQuarter = Math.floor(today.getMonth() / 3);
            const lastQuarter = currentQuarter - 1 < 0 ? 3 : currentQuarter - 1;
            const yearOfLastQuarter = lastQuarter === 3 ? today.getFullYear() - 1 : today.getFullYear();
            startDate = new Date(yearOfLastQuarter, lastQuarter * 3, 1);
            endDate = new Date(yearOfLastQuarter, lastQuarter * 3 + 3, 0);
            break;
        case 'year':
            startDate = new Date(today.getFullYear(), 0, 1);
            break;
        case 'last_year':
            startDate = new Date(today.getFullYear() - 1, 0, 1);
            endDate = new Date(today.getFullYear() - 1, 11, 31);
            break;
        case 'financial_year':
            // Assuming financial year is April 1 to March 31
            if (today.getMonth() < 3) {
                // Jan to March, use previous year's April to current year's March
                startDate = new Date(today.getFullYear() - 1, 3, 1);
                endDate = new Date(today.getFullYear(), 2, 31);
            } else {
                // April to Dec, use current year's April to next year's March
                startDate = new Date(today.getFullYear(), 3, 1);
                endDate = new Date(today.getFullYear() + 1, 2, 31);
            }
            break;
    }
    
    $('#startDate').val(startDate.toISOString().split('T')[0]);
    $('#endDate').val(endDate.toISOString().split('T')[0]);
}

function generateReports() {
    const startDate = $('#startDate').val();
    const endDate = $('#endDate').val();
    const reportType = $('#reportType').val();
    
    // Show/hide report sections based on report type
    if (reportType === 'all' || reportType === 'financial') {
        $('.financial-report').show();
    } else {
        $('.financial-report').hide();
    }
    
    if (reportType === 'all' || reportType === 'membership') {
        $('.membership-report').show();
    } else {
        $('.membership-report').hide();
    }
    
    if (reportType === 'all' || reportType === 'events') {
        $('.events-report').show();
    } else {
        $('.events-report').hide();
    }
    
    // Update summary cards
    $.get('api/reports/fetch_report_summary.php', {
        start_date: startDate, 
        end_date: endDate,
        report_type: reportType
    }, function(response) {
        if (response.success) {
            const data = response.data;
            $('#totalMembers').text(data.total_members);
            
            // Format revenue with plus sign and green color
            const revenue = parseFloat(data.total_revenue);
            $('#totalRevenue').html(`<span class="text-success">+₹${revenue.toLocaleString()}</span>`);
            
            $('#totalEvents').text(data.total_events);
            
            // Format pending payments with appropriate styling
            const pendingPayments = parseFloat(data.pending_payments);
            $('#pendingPayments').html(`<span class="text-danger">₹${pendingPayments.toLocaleString()}</span>`);
        }
    });
    
    // Update charts
    updateCharts(startDate, endDate, reportType);
    
    // Update tables
    updateSummaryTables(startDate, endDate, reportType);
    
    // Reload data tables
    if (reportType === 'all' || reportType === 'events') {
        $('#eventReportTable').DataTable().ajax.reload();
    }
    
    if (reportType === 'all' || reportType === 'financial') {
        $('#detailedFinanceTable').DataTable().ajax.reload();
    }
}

function initializeCharts() {
    // Revenue Chart
    const revenueCtx = document.getElementById('revenueChart').getContext('2d');
    revenueChart = new Chart(revenueCtx, {
        type: 'line',
        data: {
            labels: [],
            datasets: [{
                label: 'Revenue',
                data: [],
                borderColor: 'rgb(75, 192, 192)',
                backgroundColor: 'rgba(75, 192, 192, 0.2)',
                tension: 0.1
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false
        }
    });
    
    // Membership Chart
    const membershipCtx = document.getElementById('membershipChart').getContext('2d');
    membershipChart = new Chart(membershipCtx, {
        type: 'bar',
        data: {
            labels: [],
            datasets: [{
                label: 'New Members',
                data: [],
                backgroundColor: 'rgba(54, 162, 235, 0.8)'
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false
        }
    });
    
    // Event Chart
    const eventCtx = document.getElementById('eventChart').getContext('2d');
    eventChart = new Chart(eventCtx, {
        type: 'doughnut',
        data: {
            labels: [],
            datasets: [{
                data: [],
                backgroundColor: [
                    '#FF6384',
                    '#36A2EB',
                    '#FFCE56',
                    '#4BC0C0',
                    '#9966FF'
                ]
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false
        }
    });
    
    // Payment Chart
    const paymentCtx = document.getElementById('paymentChart').getContext('2d');
    paymentChart = new Chart(paymentCtx, {
        type: 'pie',
        data: {
            labels: [],
            datasets: [{
                data: [],
                backgroundColor: [
                    '#FF6384',
                    '#36A2EB',
                    '#FFCE56',
                    '#4BC0C0'
                ]
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false
        }
    });
}

function updateCharts(startDate, endDate, reportType) {
    // Update revenue chart if financial reports are included
    if (reportType === 'all' || reportType === 'financial') {
        $.get('api/charts/fetch_revenue_chart.php', {
            start_date: startDate, 
            end_date: endDate
        }, function(response) {
            if (response.success) {
                revenueChart.data.labels = response.data.labels;
                revenueChart.data.datasets[0].data = response.data.values;
                revenueChart.update();
            }
        });
        
        // Update payment chart
        $.get('api/charts/fetch_payment_chart.php', {
            start_date: startDate, 
            end_date: endDate
        }, function(response) {
            if (response.success) {
                paymentChart.data.labels = response.data.labels;
                paymentChart.data.datasets[0].data = response.data.values;
                paymentChart.update();
            }
        });
    }
    
    // Update membership chart if membership reports are included
    if (reportType === 'all' || reportType === 'membership') {
        $.get('api/charts/fetch_membership_chart.php', {
            start_date: startDate, 
            end_date: endDate
        }, function(response) {
            if (response.success) {
                membershipChart.data.labels = response.data.labels;
                membershipChart.data.datasets[0].data = response.data.values;
                membershipChart.update();
            }
        });
    }
    
    // Update event chart if event reports are included
    if (reportType === 'all' || reportType === 'events') {
        $.get('api/charts/fetch_event_chart.php', {
            start_date: startDate, 
            end_date: endDate
        }, function(response) {
            if (response.success) {
                eventChart.data.labels = response.data.labels;
                eventChart.data.datasets[0].data = response.data.values;
                eventChart.update();
            }
        });
    }
}

function updateSummaryTables(startDate, endDate, reportType) {
    // Financial summary if financial reports are included
    if (reportType === 'all' || reportType === 'financial') {
        $.get('api/finance/fetch_financial_summary.php', {
            start_date: startDate, 
            end_date: endDate
        }, function(response) {
            if (response.success) {
                let html = '';
                response.data.forEach(function(item) {
                    // Determine if this is an income or expense category
                    const isIncome = item.category.includes('(Income)') || item.category.includes('(Credit)');
                    const amountClass = isIncome ? 'text-success' : 'text-danger';
                    const amountPrefix = isIncome ? '+' : '-';
                    
                    html += `<tr>
                        <td>${item.category}</td>
                        <td><span class="${amountClass} font-weight-bold">${amountPrefix}₹${parseFloat(item.amount).toLocaleString()}</span></td>
                        <td>${item.count}</td>
                    </tr>`;
                });
                $('#financialSummary').html(html);
            }
        });
    }
    
    // Member summary if membership reports are included
    if (reportType === 'all' || reportType === 'membership') {
        $.get('api/fetch_member_summary.php', {
            start_date: startDate, 
            end_date: endDate
        }, function(response) {
            if (response.success) {
                let html = '';
                response.data.forEach(function(item) {
                    html += `<tr>
                        <td>${item.status}</td>
                        <td>${item.count}</td>
                        <td>${item.percentage}%</td>
                    </tr>`;
                });
                $('#memberSummary').html(html);
            }
        });
    }
}

function exportReport(type) {
    const startDate = $('#startDate').val();
    const endDate = $('#endDate').val();
    
    // Open export modal
    $('#exportModal').modal('show');
    
    // Store report type for export
    $('#exportReportType').val(type);
    $('#exportStartDate').val(startDate);
    $('#exportEndDate').val(endDate);
    
    // Update modal title based on report type
    const reportTitles = {
        'financial': 'Financial Summary Report',
        'members': 'Members Report',
        'detailed_finance': 'Detailed Financial Report',
        'events': 'Events Report'
    };
    
    $('#exportModalLabel').text('Export ' + (reportTitles[type] || 'Report'));
}

function processExport() {
    const type = $('#exportReportType').val();
    const startDate = $('#exportStartDate').val();
    const endDate = $('#exportEndDate').val();
    const format = $('#exportFormat').val();
    const includeCharts = $('#includeCharts').is(':checked') ? '1' : '0';
    const includeSummary = $('#includeSummary').is(':checked') ? '1' : '0';
    const includeDetails = $('#includeDetails').is(':checked') ? '1' : '0';
    
    // Show loading indicator
    const exportBtn = $('.modal-footer .btn-primary');
    const originalText = exportBtn.html();
    exportBtn.html('<i class="fas fa-spinner fa-spin"></i> Processing...');
    exportBtn.prop('disabled', true);
    
    // Close modal after a short delay to show processing
    setTimeout(function() {
        $('#exportModal').modal('hide');
        
        // Reset button state
        exportBtn.html(originalText);
        exportBtn.prop('disabled', false);
        
        // Open export endpoint in a new tab
        window.open(`api/reports/export_report.php?type=${type}&start_date=${startDate}&end_date=${endDate}&format=${format}&includeCharts=${includeCharts}&includeSummary=${includeSummary}&includeDetails=${includeDetails}`, '_blank');
        
        // Show success toast
        toastr.success(`Report is being generated in ${format.toUpperCase()} format`);
    }, 1000);
}
</script>

<?php require_once 'templates/footer.php'; ?>
