#!/usr/bin/env php
<?php
/**
 * Assignment Reminder Script
 * 
 * This script sends reminders for assignments that are:
 * 1. Upcoming (due within 48 hours)
 * 2. Overdue
 * 3. Inactive (no updates in 7+ days)
 * 
 * It should be scheduled to run daily via cron job or scheduled task:
 * 
 * Example cron entry (daily at 7am):
 * 0 7 * * * php /path/to/public_html/adminlte/scripts/send_assignment_reminders.php >> /path/to/logs/reminders.log 2>&1
 */

// Set script execution time limit to 10 minutes
set_time_limit(600);

// Define the root path
define('ROOT_PATH', dirname(__DIR__, 1));

// Include the reminder service
require_once ROOT_PATH . '/services/assignment/AssignmentReminderService.php';

// Log the start of the script
echo "Starting assignment reminders at " . date('Y-m-d H:i:s') . "\n";

// Initialize and run the reminder service
$reminderService = new AssignmentReminderService();
$reminderService->sendReminders();

// Log the completion of the script
echo "Completed assignment reminders at " . date('Y-m-d H:i:s') . "\n";

// Exit with success code
exit(0);
