# PowerShell script to set up finance tables

# Database connection info
$DB_USER = "root"  # Replace with your database username
$DB_PASS = ""      # Replace with your database password
$DB_NAME = "kso_chandigarh"  # Replace with your database name
$SQL_FILE = ".\database\finance_tables.sql"

# Check if SQL file exists
if (-not (Test-Path $SQL_FILE)) {
    Write-Host "SQL file not found: $SQL_FILE" -ForegroundColor Red
    exit 1
}

# Check if mysql command is available
try {
    $mysqlPath = Get-Command mysql -ErrorAction Stop
    Write-Host "MySQL client found at: $($mysqlPath.Source)" -ForegroundColor Green
} catch {
    Write-Host "MySQL client not found in PATH. Please make sure MySQL is installed and added to your PATH." -ForegroundColor Red
    Write-Host "You can manually run the SQL file using your preferred MySQL client with the file: $SQL_FILE" -ForegroundColor Yellow
    exit 1
}

# Execute the SQL file
Write-Host "Setting up finance tables in $DB_NAME database..." -ForegroundColor Cyan

if ([string]::IsNullOrEmpty($DB_PASS)) {
    # No password provided
    mysql -u "$DB_USER" "$DB_NAME" < "$SQL_FILE"
} else {
    # Password provided
    mysql -u "$DB_USER" --password="$DB_PASS" "$DB_NAME" < "$SQL_FILE"
}

# Check if the execution was successful
if ($LASTEXITCODE -eq 0) {
    Write-Host "Finance tables setup completed successfully!" -ForegroundColor Green
} else {
    Write-Host "Error setting up finance tables. Please check your database connection or SQL file." -ForegroundColor Red
    exit 1
}

Write-Host "You can now use the financial management system with debit/credit functionality." -ForegroundColor Cyan
