#!/bin/bash

# Path to the SQL file
SQL_FILE="./database/finance_tables.sql"

# Database connection info
DB_USER="root"  # Replace with your database username
DB_PASS=""      # Replace with your database password
DB_NAME="kso_chandigarh"  # Replace with your database name

# Check if SQL file exists
if [ ! -f "$SQL_FILE" ]; then
    echo "SQL file not found: $SQL_FILE"
    exit 1
fi

# Execute the SQL file
echo "Setting up finance tables in $DB_NAME database..."

if [ -z "$DB_PASS" ]; then
    # No password provided
    mysql -u "$DB_USER" "$DB_NAME" < "$SQL_FILE"
else
    # Password provided
    mysql -u "$DB_USER" -p"$DB_PASS" "$DB_NAME" < "$SQL_FILE"
fi

# Check if the execution was successful
if [ $? -eq 0 ]; then
    echo "Finance tables setup completed successfully!"
else
    echo "Error setting up finance tables. Please check your database connection or SQL file."
    exit 1
fi

echo "You can now use the financial management system with debit/credit functionality."
