<?php
// This is a simple test script to see if the API is accessible
header('Content-Type: text/html');
echo "<h1>Testing API Connectivity</h1>";

$apiUrl = 'api/register_member.php';
echo "<p>Testing access to: $apiUrl</p>";

// Test if file exists
if (file_exists($apiUrl)) {
    echo "<p style='color:green'>✓ API file exists!</p>";
} else {
    echo "<p style='color:red'>✗ API file not found!</p>";
}

// Test with a simple curl request
$ch = curl_init('http://' . $_SERVER['HTTP_HOST'] . '/adminlte/api/register_member.php');
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_HEADER, true);
curl_setopt($ch, CURLOPT_NOBODY, true);
curl_setopt($ch, CURLOPT_TIMEOUT, 5);
$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

echo "<p>HTTP Status Code: $httpCode</p>";
if ($httpCode >= 200 && $httpCode < 300) {
    echo "<p style='color:green'>✓ API endpoint is accessible!</p>";
} else {
    echo "<p style='color:red'>✗ API endpoint returned error: $httpCode</p>";
}

// Show the actual path to the register_member.php file
$actualPath = realpath(__DIR__ . '/api/register_member.php');
echo "<p>Actual path to API file: $actualPath</p>";

echo "<h2>Directory Structure</h2>";
echo "<pre>";
echo shell_exec('dir api /b');
echo "</pre>";
?>
