# API Directory Structure - KSO Chandigarh Management System

## Overview
The API has been reorganized into logical subfolders based on functionality and relationships for better maintainability and organization.

## Directory Structure

### `/api/auth/` - Authentication & Authorization
- `refresh_session.php` - Session management and refresh
- `create_admin.php` - Admin user creation

### `/api/dashboard/` - Dashboard Data & Analytics
- `enhanced-dashboard-data.php` - Enhanced dashboard data aggregation
- `fetch_dashboard_stats.php` - Main dashboard statistics
- `fetch_activity_logs.php` - System activity logging

### `/api/finance/` - Financial Management
#### Core Finance
- `fetch_finance.php` - General financial data
- `fetch_finance_stats.php` - Financial statistics
- `fetch_financial_summary.php` - Financial summary reports
- `fetch_budget_overview.php` - Budget analysis
- `fetch_category_statistics.php` - Expense category analytics

#### Transactions
- `fetch_transactions.php` - Transaction listing
- `fetch_recent_transactions.php` - Recent transaction data
- `add_transaction.php` - Add new transactions
- `generate_receipt.php` - Receipt generation

#### Membership Fees
- `fetch_membership_fees.php` - Membership fee data
- `fetch_membership_stats.php` - Membership payment statistics
- `fetch_fee_structure.php` - Fee structure configuration

#### Expenses
- `fetch_expense_categories.php` - Expense category management

### `/api/charts/` - Data Visualization
- `fetch_event_chart.php` - Event-related charts
- `fetch_membership_chart.php` - Membership analytics charts
- `fetch_payment_chart.php` - Payment trend charts
- `fetch_revenue_chart.php` - Revenue visualization

### `/api/reports/` - Report Generation
- `export_report.php` - General report export functionality
- `fetch_event_reports.php` - Event-specific reports
- `fetch_report_summary.php` - Report summary data

### `/api/system/` - System Management
#### Settings
- `fetch_settings.php` - Application settings
- `fetch_system_settings.php` - System configuration
- `save_system_settings.php` - Save system settings
- `add_setting.php` - Add new settings
- `delete_setting.php` - Remove settings
- `update_settings.php` - Update existing settings

#### Security & Monitoring
- `fetch_security_logs.php` - Security audit logs
- `fetch_security_stats.php` - Security statistics

#### Backup & Maintenance
- `create_backup.php` - Database backup creation
- `download_backup.php` - Backup file download
- `restore_backup.php` - Database restoration

### `/api/` (Root Level) - Core Operations
#### Members Management
- `fetch_members.php` - Member listing with enhanced data
- `fetch_member_details.php` - Individual member details
- `fetch_member_stats.php` - Member statistics
- `fetch_member_summary.php` - Member summary data
- `fetch_members_dropdown.php` - Member dropdown options
- `fetch_recent_members.php` - Recent member registrations
- `add_member.php` - Add new members
- `register_member.php` - Member registration
- `approve_member.php` - Member approval process

#### Events Management
- `fetch_events.php` - Event listing
- `fetch_event_details.php` - Individual event details
- `fetch_event_stats.php` - Event statistics
- `fetch_event_registrations.php` - Event registration data
- `fetch_upcoming_events.php` - Upcoming events
- `fetch_calendar_events.php` - Calendar integration
- `add_event.php` - Add new events
- `update_event.php` - Update existing events
- `get_event.php` - Get specific event data
- `create_quick_event.php` - Quick event creation
- `add_event_registration.php` - Event registration management
- `delete_event_registration.php` - Remove event registrations

#### Notifications
- `fetch_notifications.php` - Notification listing
- `fetch_notification_stats.php` - Notification statistics
- `create_notification.php` - Create notifications
- `delete_notification.php` - Remove notifications

#### Registration & Statistics
- `fetch_registration_stats.php` - Registration analytics
- `fetch_all_users.php` - All user data

#### Utility
- `datatable.php` - DataTable helper functions
- `check-members-table.php` - Database table validation
- `send_test_email.php` - Email testing functionality

### Existing Specialized Folders
- `/api/admin/` - Admin-specific operations
- `/api/admins/` - Admin management
- `/api/assignments/` - Assignment management
- `/api/config/` - Configuration files
- `/api/documents/` - Document management
- `/api/email/` - Email operations
- `/api/events/` - Extended event operations
- `/api/id-cards/` - ID card generation
- `/api/invoices/` - Invoice management
- `/api/logs/` - Logging operations
- `/api/member-approval/` - Member approval workflow
- `/api/members/` - Extended member operations
- `/api/notifications/` - Extended notification system
- `/api/receipts/` - Receipt management
- `/api/renewal/` - Membership renewal
- `/api/uploads/` - File upload handling

## Usage Notes
1. All APIs maintain backward compatibility with existing frontend calls
2. Authentication is required for most endpoints via `isAuthenticated()` function
3. Error handling follows consistent JSON response format
4. Database connections use the centralized Database class
5. File paths use `__DIR__` for proper relative path resolution

## Migration Guide
When updating frontend calls, update paths to reflect new structure:
- Old: `api/fetch_finance_stats.php`
- New: `api/finance/fetch_finance_stats.php`

Generated: <?php echo date('Y-m-d H:i:s'); ?>
