<?php
session_start();
require_once '../config/config.php';

header('Content-Type: application/json');

if (!isset($_SESSION['admin_id'])) {
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => 'Unauthorized']);
    exit();
}

// Check if the user has sufficient permissions
$admin_level = $_SESSION['admin_level'] ?? 0;
if ($admin_level < 8) {
    http_response_code(403);
    echo json_encode(['success' => false, 'message' => 'Insufficient permissions']);
    exit();
}

try {
    // Define all available permissions with descriptions and required admin levels
    $available_permissions = [
        'view_dashboard' => [
            'description' => 'View dashboard and statistics',
            'min_level' => 4,
            'category' => 'general'
        ],
        'manage_members' => [
            'description' => 'Manage members (view, add, edit, delete)',
            'min_level' => 5,
            'category' => 'members'
        ],
        'approve_members' => [
            'description' => 'Approve/reject member applications',
            'min_level' => 6,
            'category' => 'members'
        ],
        'manage_events' => [
            'description' => 'Manage events (create, edit, delete)',
            'min_level' => 6,
            'category' => 'events'
        ],
        'manage_registrations' => [
            'description' => 'Manage event registrations and attendance',
            'min_level' => 6,
            'category' => 'events'
        ],
        'manage_finances' => [
            'description' => 'Manage finances (transactions, expenses)',
            'min_level' => 7,
            'category' => 'finance'
        ],
        'issue_receipts' => [
            'description' => 'Issue and manage receipts/invoices',
            'min_level' => 7,
            'category' => 'finance'
        ],
        'manage_documents' => [
            'description' => 'Manage documents and templates',
            'min_level' => 6,
            'category' => 'documents'
        ],
        'manage_id_cards' => [
            'description' => 'Issue and manage ID cards',
            'min_level' => 6,
            'category' => 'documents'
        ],
        'send_communications' => [
            'description' => 'Send emails and notifications',
            'min_level' => 7,
            'category' => 'communications'
        ],
        'view_reports' => [
            'description' => 'View reports and analytics',
            'min_level' => 5,
            'category' => 'reports'
        ],
        'manage_settings' => [
            'description' => 'Manage system settings',
            'min_level' => 8,
            'category' => 'system'
        ],
        'manage_admins' => [
            'description' => 'Manage administrators',
            'min_level' => 9,
            'category' => 'system'
        ],
        'backup_restore' => [
            'description' => 'Perform database backup and restore',
            'min_level' => 9,
            'category' => 'system'
        ],
        'view_logs' => [
            'description' => 'View system and activity logs',
            'min_level' => 8,
            'category' => 'system'
        ]
    ];
    
    // Filter permissions based on the current admin's level
    $filtered_permissions = [];
    foreach ($available_permissions as $key => $permission) {
        if ($admin_level >= $permission['min_level']) {
            $filtered_permissions[$key] = $permission;
        }
    }
    
    // Group permissions by category
    $categories = [];
    foreach ($filtered_permissions as $key => $permission) {
        $category = $permission['category'];
        if (!isset($categories[$category])) {
            $categories[$category] = [];
        }
        $categories[$category][$key] = $permission;
    }
    
    echo json_encode([
        'success' => true,
        'permissions' => $filtered_permissions,
        'categories' => $categories
    ]);
    
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'message' => 'Error: ' . $e->getMessage()
    ]);
}
?>
