<?php
/**
 * API endpoint to list member assignments
 * 
 * GET Parameters:
 * - member_id: Member ID to get assignments for
 */

// Include dependencies
require_once '../../config/database.php';
require_once '../../config/auth_enhanced.php';
require_once '../../services/assignment/AssignmentService.php';

use Services\Assignment\AssignmentService;

// Require admin access for viewing member assignments
requireAdmin();

// Default response structure
$response = [
    'success' => false,
    'data' => [],
    'message' => 'Error retrieving member assignments'
];

// Handle request
if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    try {
        // Validate required parameters
        if (!isset($_GET['member_id']) || empty($_GET['member_id'])) {
            throw new Exception("Parameter 'member_id' is required");
        }
        
        // Get member ID
        $memberId = (int)$_GET['member_id'];
        
        // Create assignment service
        $assignmentService = new AssignmentService();
        
        // Get member assignments
        $result = $assignmentService->getMemberAssignments($memberId);
        
        // Return response
        $response = $result;
        
    } catch (Exception $e) {
        $response['message'] = 'Error: ' . $e->getMessage();
    }
} else {
    // Method not allowed
    http_response_code(405);
    $response['message'] = 'Method not allowed. Use GET.';
}

// Send JSON response
header('Content-Type: application/json');
echo json_encode($response);
exit;
