<?php
require_once '../config/database.php';
header('Content-Type: application/json');

try {
    $pdo = getDBConnection();
    $event_id = $_GET['id'] ?? '';

    if (empty($event_id)) {
        echo json_encode(['success' => false, 'message' => 'Event ID required']);
        exit;
    }

    // Check if events table exists
    $stmt = $pdo->query("SHOW TABLES LIKE 'events'");
    if ($stmt->rowCount() == 0) {
        echo json_encode(['success' => false, 'message' => 'Events table not found']);
        exit;
    }

    $stmt = $pdo->prepare("SELECT * FROM events WHERE id = ?");
    $stmt->execute([$event_id]);
    $event = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$event) {
        echo json_encode(['success' => false, 'message' => 'Event not found']);
        exit;
    }

    echo json_encode(['success' => true, 'data' => $event]);

} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => 'Error: ' . $e->getMessage()]);
}
?>
