<?php
/**
 * Member List API Endpoint
 * 
 * Retrieves a list of all members
 */

// Initialize the session if not already started
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Include database connection
require_once __DIR__ . '/../../config/db_connect.php';

// Check authentication
if (!isset($_SESSION['admin_id'])) {
    header('Content-Type: application/json');
    echo json_encode([
        'success' => false,
        'message' => 'Authentication required'
    ]);
    exit;
}

try {
    // Get all members
    $query = "
        SELECT id, kso_id, first_name, last_name, email, phone, membership_status
        FROM members
        ORDER BY first_name, last_name
    ";
    
    $result = $conn->query($query);
    
    $members = [];
    while ($row = $result->fetch_assoc()) {
        $members[] = $row;
    }
    
    // Return members
    header('Content-Type: application/json');
    echo json_encode([
        'success' => true,
        'data' => $members
    ]);
} catch (Exception $e) {
    header('Content-Type: application/json');
    echo json_encode([
        'success' => false,
        'message' => 'Error retrieving members: ' . $e->getMessage()
    ]);
}
