<?php
// Include initialization file for clean URLs
require_once 'init.php';

// Include authentication check
require_once 'config/auth_enhanced.php';
checkAuthentication();

// Page title and current section for menu highlighting
$pageTitle = "Assignment Management";
$currentSection = "assignments";
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>KSO Admin | <?php echo $pageTitle; ?></title>

  <!-- Google Font: Source Sans Pro -->
  <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700&display=fallback">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="plugins/fontawesome-free/css/all.min.css">
  <!-- DataTables -->
  <link rel="stylesheet" href="plugins/datatables-bs4/css/dataTables.bootstrap4.min.css">
  <link rel="stylesheet" href="plugins/datatables-responsive/css/responsive.bootstrap4.min.css">
  <link rel="stylesheet" href="plugins/datatables-buttons/css/buttons.bootstrap4.min.css">
  <!-- SweetAlert2 -->
  <link rel="stylesheet" href="plugins/sweetalert2-theme-bootstrap-4/bootstrap-4.min.css">
  <!-- Select2 -->
  <link rel="stylesheet" href="plugins/select2/css/select2.min.css">
  <link rel="stylesheet" href="plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css">
  <!-- Theme style -->
  <link rel="stylesheet" href="dist/css/adminlte.min.css">
  <!-- Custom styles -->
  <style>
    .assignment-card {
      transition: all 0.3s ease;
    }
    .assignment-card:hover {
      transform: translateY(-5px);
      box-shadow: 0 10px 20px rgba(0,0,0,0.1);
    }
    .priority-urgent {
      border-left: 4px solid #dc3545 !important;
    }
    .priority-high {
      border-left: 4px solid #fd7e14 !important;
    }
    .priority-normal {
      border-left: 4px solid #17a2b8 !important;
    }
    .priority-low {
      border-left: 4px solid #6c757d !important;
    }
    .status-badge {
      position: absolute;
      top: 10px;
      right: 10px;
    }
    .due-date-warning {
      color: #dc3545;
      font-weight: bold;
    }
    .select2-container--bootstrap4 .select2-selection--multiple .select2-selection__choice {
      background-color: #007bff;
      border-color: #006fe6;
      color: #fff;
    }
    /* Mobile responsive adjustments */
    @media (max-width: 768px) {
      .action-buttons .btn {
        margin-bottom: 5px;
        display: block;
        width: 100%;
      }
      .card-tools {
        margin-top: 10px;
        display: block;
        width: 100%;
      }
    }
    /* Real-time notification indicator */
    .pulse-animation {
      display: inline-block;
      width: 10px;
      height: 10px;
      border-radius: 50%;
      background: #28a745;
      margin-right: 5px;
      animation: pulse 2s infinite;
    }
    @keyframes pulse {
      0% {
        box-shadow: 0 0 0 0 rgba(40, 167, 69, 0.7);
      }
      70% {
        box-shadow: 0 0 0 10px rgba(40, 167, 69, 0);
      }
      100% {
        box-shadow: 0 0 0 0 rgba(40, 167, 69, 0);
      }
    }
  </style>
</head>
<body class="hold-transition sidebar-mini">
<div class="wrapper">

  <!-- Include navbar and sidebar -->
  <?php include 'templates/navbar.php'; ?>
  <?php include 'templates/sidebar.php'; ?>

  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1><?php echo $pageTitle; ?></h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="index.php">Home</a></li>
              <li class="breadcrumb-item active"><?php echo $pageTitle; ?></li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>

    <!-- Main content -->
    <section class="content">
      <div class="container-fluid">
      
        <!-- Assignment Statistics -->
        <div class="row">
          <div class="col-lg-3 col-6">
            <!-- small box -->
            <div class="small-box bg-info">
              <div class="inner">
                <h3 id="totalAssignments">0</h3>
                <p>Total Assignments</p>
              </div>
              <div class="icon">
                <i class="fas fa-tasks"></i>
              </div>
              <a href="#" class="small-box-footer" data-toggle="modal" data-target="#assignmentStatsModal">
                More info <i class="fas fa-arrow-circle-right"></i>
              </a>
            </div>
          </div>
          <!-- ./col -->
          <div class="col-lg-3 col-6">
            <!-- small box -->
            <div class="small-box bg-success">
              <div class="inner">
                <h3 id="completedAssignments">0</h3>
                <p>Completed</p>
              </div>
              <div class="icon">
                <i class="fas fa-check-circle"></i>
              </div>
              <a href="#" class="small-box-footer" data-filter="completed" id="filterCompleted">
                View completed <i class="fas fa-arrow-circle-right"></i>
              </a>
            </div>
          </div>
          <!-- ./col -->
          <div class="col-lg-3 col-6">
            <!-- small box -->
            <div class="small-box bg-warning">
              <div class="inner">
                <h3 id="pendingAssignments">0</h3>
                <p>Pending</p>
              </div>
              <div class="icon">
                <i class="fas fa-clock"></i>
              </div>
              <a href="#" class="small-box-footer" data-filter="active" id="filterPending">
                View pending <i class="fas fa-arrow-circle-right"></i>
              </a>
            </div>
          </div>
          <!-- ./col -->
          <div class="col-lg-3 col-6">
            <!-- small box -->
            <div class="small-box bg-danger">
              <div class="inner">
                <h3 id="overdueAssignments">0</h3>
                <p>Overdue</p>
              </div>
              <div class="icon">
                <i class="fas fa-exclamation-triangle"></i>
              </div>
              <a href="#" class="small-box-footer" data-filter="overdue" id="filterOverdue">
                View overdue <i class="fas fa-arrow-circle-right"></i>
              </a>
            </div>
          </div>
          <!-- ./col -->
        </div>
        <!-- /.row -->

        <!-- Real-time Updates Status -->
        <div class="row mb-3">
          <div class="col-12">
            <div class="alert alert-success" role="alert">
              <div class="d-flex align-items-center">
                <span class="pulse-animation"></span>
                <strong>Real-time updates active</strong> - Assignment changes will appear instantly
                <button type="button" class="btn btn-sm btn-outline-success ml-auto" id="refreshAssignments">
                  <i class="fas fa-sync-alt"></i> Manual Refresh
                </button>
              </div>
            </div>
          </div>
        </div>

        <!-- Assignment Management Tools -->
        <div class="row mb-3">
          <div class="col-md-12">
            <div class="card card-primary card-outline">
              <div class="card-header">
                <h3 class="card-title">
                  <i class="fas fa-tasks mr-1"></i>
                  Assignment Management
                </h3>
                <div class="card-tools">
                  <button type="button" class="btn btn-success" data-toggle="modal" data-target="#createAssignmentModal">
                    <i class="fas fa-plus"></i> Create Assignment
                  </button>
                  <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#bulkAssignModal">
                    <i class="fas fa-user-tag"></i> Bulk Assign
                  </button>
                  <button type="button" class="btn btn-warning" data-toggle="modal" data-target="#batchUpdateModal">
                    <i class="fas fa-edit"></i> Batch Update
                  </button>
                </div>
              </div>
              <div class="card-body">
                <!-- Assignment Filters -->
                <div class="row mb-3">
                  <div class="col-md-12">
                    <div class="btn-group mb-2">
                      <button type="button" class="btn btn-default active" data-filter="all">All Assignments</button>
                      <button type="button" class="btn btn-default" data-filter="active">Active</button>
                      <button type="button" class="btn btn-default" data-filter="completed">Completed</button>
                      <button type="button" class="btn btn-default" data-filter="cancelled">Cancelled</button>
                      <button type="button" class="btn btn-default" data-filter="overdue">Overdue</button>
                    </div>
                    
                    <div class="btn-group mb-2 ml-md-2">
                      <button type="button" class="btn btn-default" data-priority-filter="all">All Priorities</button>
                      <button type="button" class="btn btn-default" data-priority-filter="urgent">
                        <i class="fas fa-exclamation-circle text-danger"></i> Urgent
                      </button>
                      <button type="button" class="btn btn-default" data-priority-filter="high">
                        <i class="fas fa-arrow-up text-warning"></i> High
                      </button>
                      <button type="button" class="btn btn-default" data-priority-filter="normal">
                        <i class="fas fa-minus text-info"></i> Normal
                      </button>
                      <button type="button" class="btn btn-default" data-priority-filter="low">
                        <i class="fas fa-arrow-down text-secondary"></i> Low
                      </button>
                    </div>
                  </div>
                </div>
                
                <!-- Assignment Search -->
                <div class="row mb-3">
                  <div class="col-md-12">
                    <div class="input-group">
                      <input type="text" class="form-control" placeholder="Search assignments..." id="assignmentSearch">
                      <div class="input-group-append">
                        <button class="btn btn-outline-secondary" type="button" id="searchButton">
                          <i class="fas fa-search"></i>
                        </button>
                      </div>
                    </div>
                  </div>
                </div>
                
                <!-- Assignment Data Table -->
                <div class="table-responsive">
                  <table id="assignmentsTable" class="table table-bordered table-striped">
                    <thead>
                      <tr>
                        <th><input type="checkbox" id="selectAll"></th>
                        <th>ID</th>
                        <th>Title</th>
                        <th>Member</th>
                        <th>Assigned To</th>
                        <th>Type</th>
                        <th>Priority</th>
                        <th>Status</th>
                        <th>Due Date</th>
                        <th>Actions</th>
                      </tr>
                    </thead>
                    <tbody id="assignmentsTableBody">
                      <!-- Assignment data will be loaded here -->
                      <tr id="noAssignmentsRow">
                        <td colspan="10" class="text-center">
                          <div class="alert alert-info m-3">
                            <i class="fas fa-info-circle mr-2"></i> No assignments found...
                          </div>
                        </td>
                      </tr>
                    </tbody>
                  </table>
                </div>
              </div>
            </div>
          </div>
        </div>
        
        <!-- Recent Activity & Due Soon -->
        <div class="row">
          <!-- Recent Activity -->
          <div class="col-md-6">
            <div class="card card-primary">
              <div class="card-header">
                <h3 class="card-title">Recent Assignment Activity</h3>
                <div class="card-tools">
                  <button type="button" class="btn btn-tool" data-card-widget="collapse">
                    <i class="fas fa-minus"></i>
                  </button>
                </div>
              </div>
              <div class="card-body p-0">
                <ul class="products-list product-list-in-card pl-2 pr-2" id="recentActivityList">
                  <li class="item">
                    <div class="product-info">
                      <div class="text-center py-3">
                        <i class="fas fa-spinner fa-spin mr-2"></i> Loading recent activity...
                      </div>
                    </div>
                  </li>
                </ul>
              </div>
            </div>
          </div>
          
          <!-- Due Soon -->
          <div class="col-md-6">
            <div class="card card-warning">
              <div class="card-header">
                <h3 class="card-title">Assignments Due Soon</h3>
                <div class="card-tools">
                  <button type="button" class="btn btn-tool" data-card-widget="collapse">
                    <i class="fas fa-minus"></i>
                  </button>
                </div>
              </div>
              <div class="card-body p-0">
                <ul class="products-list product-list-in-card pl-2 pr-2" id="dueSoonList">
                  <li class="item">
                    <div class="product-info">
                      <div class="text-center py-3">
                        <i class="fas fa-spinner fa-spin mr-2"></i> Loading due soon assignments...
                      </div>
                    </div>
                  </li>
                </ul>
              </div>
              <div class="card-footer text-center">
                <a href="javascript:void(0)" class="uppercase" id="viewAllDueSoon">View All Assignments</a>
              </div>
            </div>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->

  <!-- Include footer -->
  <?php include 'templates/footer.php'; ?>

  <!-- Create Assignment Modal -->
  <div class="modal fade" id="createAssignmentModal">
    <div class="modal-dialog modal-lg">
      <div class="modal-content">
        <div class="modal-header bg-primary">
          <h4 class="modal-title">Create New Assignment</h4>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">
          <form id="createAssignmentForm">
            <div class="form-group">
              <label for="assignmentTitle">Assignment Title</label>
              <input type="text" class="form-control" id="assignmentTitle" placeholder="Enter assignment title" required>
            </div>
            <div class="form-group">
              <label for="assignmentDescription">Description</label>
              <textarea class="form-control" id="assignmentDescription" rows="3" placeholder="Enter assignment description"></textarea>
            </div>
            <div class="row">
              <div class="col-md-6">
                <div class="form-group">
                  <label for="assignMemberId">Member</label>
                  <select class="form-control select2" id="assignMemberId" required>
                    <option value="">Select Member</option>
                    <!-- Options will be loaded via AJAX -->
                  </select>
                </div>
              </div>
              <div class="col-md-6">
                <div class="form-group">
                  <label for="assignToAdmin">Assign To</label>
                  <select class="form-control select2" id="assignToAdmin" required>
                    <option value="">Select Admin</option>
                    <!-- Options will be loaded via AJAX -->
                  </select>
                </div>
              </div>
            </div>
            <div class="row">
              <div class="col-md-4">
                <div class="form-group">
                  <label for="assignmentType">Assignment Type</label>
                  <select class="form-control" id="assignmentType" required>
                    <option value="">Select Type</option>
                    <option value="review">Review</option>
                    <option value="approval">Approval</option>
                    <option value="verification">Verification</option>
                    <option value="follow_up">Follow Up</option>
                    <option value="other">Other</option>
                  </select>
                </div>
              </div>
              <div class="col-md-4">
                <div class="form-group">
                  <label for="assignmentPriority">Priority</label>
                  <select class="form-control" id="assignmentPriority" required>
                    <option value="">Select Priority</option>
                    <option value="low">Low</option>
                    <option value="normal">Normal</option>
                    <option value="high">High</option>
                    <option value="urgent">Urgent</option>
                  </select>
                </div>
              </div>
              <div class="col-md-4">
                <div class="form-group">
                  <label for="assignmentDueDate">Due Date</label>
                  <input type="datetime-local" class="form-control" id="assignmentDueDate" required>
                </div>
              </div>
            </div>
            <div class="form-group">
              <div class="custom-control custom-checkbox">
                <input class="custom-control-input" type="checkbox" id="sendEmailNotification" checked>
                <label for="sendEmailNotification" class="custom-control-label">Send email notification</label>
              </div>
            </div>
          </form>
        </div>
        <div class="modal-footer justify-content-between">
          <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
          <button type="button" class="btn btn-primary" id="saveAssignmentBtn">Create Assignment</button>
        </div>
      </div>
      <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
  </div>
  <!-- /.modal -->

  <!-- Bulk Assign Modal -->
  <div class="modal fade" id="bulkAssignModal">
    <div class="modal-dialog modal-lg">
      <div class="modal-content">
        <div class="modal-header bg-primary">
          <h4 class="modal-title">Bulk Assign Members</h4>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">
          <form id="bulkAssignForm">
            <div class="form-group">
              <label for="bulkMembers">Select Members</label>
              <select class="form-control select2" id="bulkMembers" multiple="multiple" data-placeholder="Select members" required>
                <!-- Options will be loaded via AJAX -->
              </select>
            </div>
            <div class="form-group">
              <label for="bulkAssignmentTitle">Assignment Title</label>
              <input type="text" class="form-control" id="bulkAssignmentTitle" placeholder="Enter assignment title" required>
            </div>
            <div class="form-group">
              <label for="bulkAssignmentDescription">Description</label>
              <textarea class="form-control" id="bulkAssignmentDescription" rows="3" placeholder="Enter assignment description"></textarea>
            </div>
            <div class="row">
              <div class="col-md-4">
                <div class="form-group">
                  <label for="bulkAssignToAdmin">Assign To</label>
                  <select class="form-control select2" id="bulkAssignToAdmin" required>
                    <option value="">Select Admin</option>
                    <!-- Options will be loaded via AJAX -->
                  </select>
                </div>
              </div>
              <div class="col-md-4">
                <div class="form-group">
                  <label for="bulkAssignmentType">Assignment Type</label>
                  <select class="form-control" id="bulkAssignmentType" required>
                    <option value="">Select Type</option>
                    <option value="review">Review</option>
                    <option value="approval">Approval</option>
                    <option value="verification">Verification</option>
                    <option value="follow_up">Follow Up</option>
                    <option value="other">Other</option>
                  </select>
                </div>
              </div>
              <div class="col-md-4">
                <div class="form-group">
                  <label for="bulkAssignmentPriority">Priority</label>
                  <select class="form-control" id="bulkAssignmentPriority" required>
                    <option value="">Select Priority</option>
                    <option value="low">Low</option>
                    <option value="normal">Normal</option>
                    <option value="high">High</option>
                    <option value="urgent">Urgent</option>
                  </select>
                </div>
              </div>
            </div>
            <div class="row">
              <div class="col-md-6">
                <div class="form-group">
                  <label for="bulkAssignmentDueDate">Due Date</label>
                  <input type="datetime-local" class="form-control" id="bulkAssignmentDueDate" required>
                </div>
              </div>
              <div class="col-md-6">
                <div class="form-group">
                  <div class="custom-control custom-checkbox mt-4">
                    <input class="custom-control-input" type="checkbox" id="bulkSendEmailNotification" checked>
                    <label for="bulkSendEmailNotification" class="custom-control-label">Send email notifications</label>
                  </div>
                </div>
              </div>
            </div>
          </form>
        </div>
        <div class="modal-footer justify-content-between">
          <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
          <button type="button" class="btn btn-primary" id="saveBulkAssignBtn">Assign Members</button>
        </div>
      </div>
      <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
  </div>
  <!-- /.modal -->

  <!-- Batch Update Modal -->
  <div class="modal fade" id="batchUpdateModal">
    <div class="modal-dialog">
      <div class="modal-content">
        <div class="modal-header bg-warning">
          <h4 class="modal-title">Batch Update Assignments</h4>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">
          <form id="batchUpdateForm">
            <div class="alert alert-info">
              <i class="fas fa-info-circle mr-2"></i> This will update all selected assignments.
            </div>
            <div class="form-group">
              <label for="batchUpdateStatus">Update Status</label>
              <select class="form-control" id="batchUpdateStatus">
                <option value="">No Change</option>
                <option value="active">Active</option>
                <option value="completed">Completed</option>
                <option value="cancelled">Cancelled</option>
              </select>
            </div>
            <div class="form-group">
              <label for="batchUpdatePriority">Update Priority</label>
              <select class="form-control" id="batchUpdatePriority">
                <option value="">No Change</option>
                <option value="low">Low</option>
                <option value="normal">Normal</option>
                <option value="high">High</option>
                <option value="urgent">Urgent</option>
              </select>
            </div>
            <div class="form-group">
              <label for="batchUpdateAssignTo">Reassign To</label>
              <select class="form-control select2" id="batchUpdateAssignTo">
                <option value="">No Change</option>
                <!-- Options will be loaded via AJAX -->
              </select>
            </div>
            <div class="form-group">
              <label for="batchUpdateDueDate">Update Due Date</label>
              <input type="datetime-local" class="form-control" id="batchUpdateDueDate">
              <small class="form-text text-muted">Leave empty to keep current due dates</small>
            </div>
            <div class="form-group">
              <div class="custom-control custom-checkbox">
                <input class="custom-control-input" type="checkbox" id="batchUpdateSendEmail" checked>
                <label for="batchUpdateSendEmail" class="custom-control-label">Send email notifications</label>
              </div>
            </div>
          </form>
        </div>
        <div class="modal-footer justify-content-between">
          <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
          <button type="button" class="btn btn-warning" id="saveBatchUpdateBtn">Update Assignments</button>
        </div>
      </div>
      <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
  </div>
  <!-- /.modal -->

  <!-- View Assignment Modal -->
  <div class="modal fade" id="viewAssignmentModal">
    <div class="modal-dialog modal-lg">
      <div class="modal-content">
        <div class="modal-header bg-info">
          <h4 class="modal-title" id="viewAssignmentTitle">Assignment Details</h4>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">
          <div class="row">
            <div class="col-md-6">
              <dl>
                <dt>Assignment ID</dt>
                <dd id="viewAssignmentId"></dd>
                
                <dt>Title</dt>
                <dd id="viewAssignmentTitleText"></dd>
                
                <dt>Description</dt>
                <dd id="viewAssignmentDescription"></dd>
                
                <dt>Member</dt>
                <dd id="viewAssignmentMember"></dd>
              </dl>
            </div>
            <div class="col-md-6">
              <dl>
                <dt>Assigned To</dt>
                <dd id="viewAssignmentAssignedTo"></dd>
                
                <dt>Type</dt>
                <dd id="viewAssignmentType"></dd>
                
                <dt>Priority</dt>
                <dd id="viewAssignmentPriority"></dd>
                
                <dt>Status</dt>
                <dd id="viewAssignmentStatus"></dd>
                
                <dt>Due Date</dt>
                <dd id="viewAssignmentDueDate"></dd>
                
                <dt>Created</dt>
                <dd id="viewAssignmentCreated"></dd>
                
                <dt>Last Updated</dt>
                <dd id="viewAssignmentUpdated"></dd>
              </dl>
            </div>
          </div>
          
          <hr>
          
          <div class="row">
            <div class="col-md-12">
              <h5>Activity Log</h5>
              <ul class="timeline" id="assignmentActivityLog">
                <li class="time-label">
                  <span class="bg-info">Loading activity...</span>
                </li>
              </ul>
            </div>
          </div>
        </div>
        <div class="modal-footer justify-content-between">
          <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
          <div>
            <button type="button" class="btn btn-success" id="markCompletedBtn">
              <i class="fas fa-check"></i> Mark Completed
            </button>
            <button type="button" class="btn btn-primary" id="editAssignmentBtn">
              <i class="fas fa-edit"></i> Edit
            </button>
          </div>
        </div>
      </div>
      <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
  </div>
  <!-- /.modal -->

  <!-- Assignment Stats Modal -->
  <div class="modal fade" id="assignmentStatsModal">
    <div class="modal-dialog modal-lg">
      <div class="modal-content">
        <div class="modal-header bg-info">
          <h4 class="modal-title">Assignment Statistics</h4>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">
          <div class="row">
            <div class="col-md-6">
              <div class="card">
                <div class="card-header">
                  <h3 class="card-title">Assignments by Status</h3>
                </div>
                <div class="card-body">
                  <canvas id="statusChart" style="min-height: 250px; height: 250px; max-height: 250px; max-width: 100%;"></canvas>
                </div>
              </div>
            </div>
            <div class="col-md-6">
              <div class="card">
                <div class="card-header">
                  <h3 class="card-title">Assignments by Priority</h3>
                </div>
                <div class="card-body">
                  <canvas id="priorityChart" style="min-height: 250px; height: 250px; max-height: 250px; max-width: 100%;"></canvas>
                </div>
              </div>
            </div>
          </div>
          <div class="row mt-3">
            <div class="col-md-6">
              <div class="card">
                <div class="card-header">
                  <h3 class="card-title">Assignments by Type</h3>
                </div>
                <div class="card-body">
                  <canvas id="typeChart" style="min-height: 250px; height: 250px; max-height: 250px; max-width: 100%;"></canvas>
                </div>
              </div>
            </div>
            <div class="col-md-6">
              <div class="card">
                <div class="card-header">
                  <h3 class="card-title">Completion Trend</h3>
                </div>
                <div class="card-body">
                  <canvas id="completionTrendChart" style="min-height: 250px; height: 250px; max-height: 250px; max-width: 100%;"></canvas>
                </div>
              </div>
            </div>
          </div>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
        </div>
      </div>
      <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
  </div>
  <!-- /.modal -->
</div>
<!-- ./wrapper -->

<!-- jQuery -->
<script src="plugins/jquery/jquery.min.js"></script>
<!-- Bootstrap 4 -->
<script src="plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
<!-- DataTables & Plugins -->
<script src="plugins/datatables/jquery.dataTables.min.js"></script>
<script src="plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
<script src="plugins/datatables-responsive/js/dataTables.responsive.min.js"></script>
<script src="plugins/datatables-responsive/js/responsive.bootstrap4.min.js"></script>
<script src="plugins/datatables-buttons/js/dataTables.buttons.min.js"></script>
<script src="plugins/datatables-buttons/js/buttons.bootstrap4.min.js"></script>
<script src="plugins/jszip/jszip.min.js"></script>
<script src="plugins/pdfmake/pdfmake.min.js"></script>
<script src="plugins/pdfmake/vfs_fonts.js"></script>
<script src="plugins/datatables-buttons/js/buttons.html5.min.js"></script>
<script src="plugins/datatables-buttons/js/buttons.print.min.js"></script>
<!-- SweetAlert2 -->
<script src="plugins/sweetalert2/sweetalert2.min.js"></script>
<!-- Select2 -->
<script src="plugins/select2/js/select2.full.min.js"></script>
<!-- ChartJS -->
<script src="plugins/chart.js/Chart.min.js"></script>
<!-- AdminLTE App -->
<script src="dist/js/adminlte.min.js"></script>
<!-- Assignment System -->
<script src="frontend/js/assignments/assignment-system.js"></script>
<!-- Page specific script -->
<script>
  $(function () {
    // Initialize Select2 Elements
    $('.select2').select2({
      theme: 'bootstrap4'
    });
    
    // Initialize DataTable with responsive features
    $('#assignmentsTable').DataTable({
      "paging": true,
      "lengthChange": true,
      "searching": true,
      "ordering": true,
      "info": true,
      "autoWidth": false,
      "responsive": true,
      "buttons": ["excel", "pdf", "print"]
    }).buttons().container().appendTo('#assignmentsTable_wrapper .col-md-6:eq(0)');
    
    // Initialize the Assignment System
    window.assignmentSystem.init();
    
    // Load initial assignments data
    window.assignmentSystem.loadAssignments();
    
    // Load members for select dropdowns
    window.assignmentSystem.loadMembers();
    
    // Load admins for select dropdowns
    window.assignmentSystem.loadAdmins();
    
    // Initialize stats charts
    window.assignmentSystem.initCharts();
    
    // Setup real-time updates
    window.assignmentSystem.setupRealTimeUpdates();
    
    // Event handlers for various actions
    
    // Manual refresh button
    $('#refreshAssignments').on('click', function() {
      window.assignmentSystem.loadAssignments();
      window.assignmentSystem.loadStatistics();
      
      // Show refresh toast
      Swal.fire({
        toast: true,
        position: 'top-end',
        icon: 'success',
        title: 'Assignments refreshed',
        showConfirmButton: false,
        timer: 2000
      });
    });
    
    // Filter buttons
    $('.btn-group button[data-filter]').on('click', function() {
      const filter = $(this).data('filter');
      $('.btn-group button[data-filter]').removeClass('active');
      $(this).addClass('active');
      window.assignmentSystem.filterAssignments(filter);
    });
    
    // Priority filter buttons
    $('.btn-group button[data-priority-filter]').on('click', function() {
      const priorityFilter = $(this).data('priority-filter');
      $('.btn-group button[data-priority-filter]').removeClass('active');
      $(this).addClass('active');
      window.assignmentSystem.filterByPriority(priorityFilter);
    });
    
    // Quick filter links in stats boxes
    $('a[data-filter]').on('click', function(e) {
      e.preventDefault();
      const filter = $(this).data('filter');
      $('.btn-group button[data-filter]').removeClass('active');
      $(`.btn-group button[data-filter="${filter}"]`).addClass('active');
      window.assignmentSystem.filterAssignments(filter);
    });
    
    // Select all checkbox
    $('#selectAll').on('change', function() {
      const isChecked = $(this).prop('checked');
      $('.assignment-checkbox').prop('checked', isChecked);
      window.assignmentSystem.updateBatchActionButtons();
    });
    
    // Search functionality
    $('#searchButton').on('click', function() {
      const searchTerm = $('#assignmentSearch').val().toLowerCase();
      window.assignmentSystem.searchAssignments(searchTerm);
    });
    
    // Allow search on enter key
    $('#assignmentSearch').on('keypress', function(e) {
      if (e.which === 13) {
        const searchTerm = $(this).val().toLowerCase();
        window.assignmentSystem.searchAssignments(searchTerm);
      }
    });
    
    // Create assignment form submission
    $('#saveAssignmentBtn').on('click', function() {
      window.assignmentSystem.createAssignment();
    });
    
    // Bulk assign form submission
    $('#saveBulkAssignBtn').on('click', function() {
      window.assignmentSystem.bulkAssign();
    });
    
    // Batch update form submission
    $('#saveBatchUpdateBtn').on('click', function() {
      window.assignmentSystem.batchUpdate();
    });
    
    // Setup view all due soon link
    $('#viewAllDueSoon').on('click', function(e) {
      e.preventDefault();
      $('.btn-group button[data-filter]').removeClass('active');
      $('.btn-group button[data-filter="active"]').addClass('active');
      window.assignmentSystem.filterAssignments('active');
      window.assignmentSystem.sortByDueDate();
    });
  });
</script>
</body>
</html>
