<?php
/**
 * KSO Chandigarh Management System - Configuration File
 */

// Include database configuration
require_once __DIR__ . '/database.php';

// Application constants
define('APP_NAME', 'KSO Chandigarh Management System');
define('APP_VERSION', '1.0.0');
define('APP_URL', 'https://kso-chd.online/adminlte');

// File upload paths
define('UPLOAD_PATH', __DIR__ . '/../uploads');
define('PHOTO_UPLOAD_PATH', UPLOAD_PATH . '/photos');
define('DOCUMENT_UPLOAD_PATH', UPLOAD_PATH . '/documents');
define('ID_CARD_PATH', UPLOAD_PATH . '/id_cards');
define('RECEIPT_PATH', UPLOAD_PATH . '/receipts');

// Ensure upload directories exist
if (!file_exists(UPLOAD_PATH)) {
    mkdir(UPLOAD_PATH, 0755, true);
}
if (!file_exists(PHOTO_UPLOAD_PATH)) {
    mkdir(PHOTO_UPLOAD_PATH, 0755, true);
}
if (!file_exists(DOCUMENT_UPLOAD_PATH)) {
    mkdir(DOCUMENT_UPLOAD_PATH, 0755, true);
}
if (!file_exists(ID_CARD_PATH)) {
    mkdir(ID_CARD_PATH, 0755, true);
}
if (!file_exists(RECEIPT_PATH)) {
    mkdir(RECEIPT_PATH, 0755, true);
}

// PDF configuration
define('PDF_LOGO_PATH', __DIR__ . '/../assets/img/kso_logo.png');
define('PDF_HEADER_TITLE', 'Kuki Students Organization - Chandigarh');

// Email configuration
define('SMTP_HOST', 'mail.kso-chd.online');
define('SMTP_PORT', 465);
define('SMTP_USERNAME', 'info@kso-chd.online');
define('SMTP_PASSWORD', 'KSO@2025');
define('SMTP_FROM_EMAIL', 'info@kso-chd.online');
define('SMTP_FROM_NAME', 'KSO Chandigarh');

// System settings
define('RECORDS_PER_PAGE', 10);
define('DATE_FORMAT', 'd-m-Y');
define('TIME_FORMAT', 'h:i A');
define('DATETIME_FORMAT', 'd-m-Y h:i A');

// Security settings
define('PASSWORD_MIN_LENGTH', 8);

// API access definition
if (!defined('API_ACCESS')) {
    define('API_ACCESS', true);
}
