/**
 * KSO Chandigarh Preloader
 * Enhanced loading screen with KSO branding
 */

class KSOPreloader {
    constructor() {
        this.createPreloader();
        this.show();
    }

    createPreloader() {
        const preloader = document.createElement('div');
        preloader.className = 'preloader flex-column justify-content-center align-items-center';
        preloader.id = 'kso-preloader';
        preloader.innerHTML = `
            <div class="preloader-content">
                <div class="kso-logo-container">
                    <img class="animation__shake" src="public/KSO LOGO.png" alt="KUKI STUDENTS' ORGANISATION Logo" height="80" width="80">
                    <div class="kso-text">
                        <h3 class="text-primary">KUKI STUDENTS' ORGANISATION</h3>
                        <p class="text-muted">Chandigarh | Loading your dashboard...</p>
                    </div>
                </div>
                <div class="loading-spinner">
                    <div class="spinner-border text-primary" role="status">
                        <span class="sr-only">Loading...</span>
                    </div>
                </div>
                <div class="loading-progress">
                    <div class="progress">
                        <div class="progress-bar bg-primary progress-bar-striped progress-bar-animated" 
                             role="progressbar" style="width: 0%" id="loading-progress-bar"></div>
                    </div>
                    <small class="text-muted mt-2" id="loading-status">Initializing...</small>
                </div>
            </div>
        `;

        // Add styles
        const style = document.createElement('style');
        style.textContent = `
            .preloader {
                position: fixed;
                top: 0;
                left: 0;
                width: 100%;
                height: 100%;
                background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
                z-index: 9999;
                display: flex;
                flex-direction: column;
                justify-content: center;
                align-items: center;
                transition: all 0.5s ease;
            }

            .preloader-content {
                text-align: center;
                background: rgba(255, 255, 255, 0.95);
                padding: 40px;
                border-radius: 15px;
                box-shadow: 0 10px 30px rgba(0, 0, 0, 0.3);
                max-width: 350px;
                width: 90%;
            }

            .kso-logo-container {
                margin-bottom: 30px;
            }

            .kso-logo-container img {
                border-radius: 50%;
                box-shadow: 0 5px 15px rgba(0, 0, 0, 0.2);
                margin-bottom: 15px;
            }

            .kso-text h3 {
                margin: 10px 0 5px 0;
                font-weight: 600;
            }

            .kso-text p {
                margin: 0;
                font-size: 14px;
            }

            .loading-spinner {
                margin: 20px 0;
            }

            .loading-progress {
                width: 100%;
            }

            .loading-progress .progress {
                height: 6px;
                margin-bottom: 10px;
                background-color: #e9ecef;
                border-radius: 3px;
            }

            .loading-progress small {
                display: block;
                font-size: 12px;
            }

            .preloader.fade-out {
                opacity: 0;
                visibility: hidden;
            }

            /* Dark mode styles */
            .dark-mode .preloader {
                background: linear-gradient(135deg, #2c3e50 0%, #34495e 100%);
            }

            .dark-mode .preloader-content {
                background: rgba(52, 73, 94, 0.95);
                color: #ecf0f1;
            }

            .dark-mode .kso-text h3 {
                color: #3498db;
            }

            .dark-mode .kso-text p {
                color: #bdc3c7;
            }

            .dark-mode .loading-progress small {
                color: #95a5a6;
            }

            /* Animation */
            @keyframes shake {
                0%, 100% { transform: translateX(0); }
                10%, 30%, 50%, 70%, 90% { transform: translateX(-2px); }
                20%, 40%, 60%, 80% { transform: translateX(2px); }
            }

            .animation__shake {
                animation: shake 1s ease-in-out;
            }
        `;
        document.head.appendChild(style);

        // Insert preloader at the beginning of body
        document.body.insertBefore(preloader, document.body.firstChild);
    }

    show() {
        const preloader = document.getElementById('kso-preloader');
        if (preloader) {
            preloader.style.display = 'flex';
            this.simulateLoading();
        }
    }

    hide() {
        const preloader = document.getElementById('kso-preloader');
        if (preloader) {
            preloader.classList.add('fade-out');
            setTimeout(() => {
                preloader.remove();
            }, 500);
        }
    }

    simulateLoading() {
        const progressBar = document.getElementById('loading-progress-bar');
        const statusText = document.getElementById('loading-status');
        
        const loadingSteps = [
            { progress: 20, status: 'Loading configuration...' },
            { progress: 40, status: 'Connecting to database...' },
            { progress: 60, status: 'Fetching user data...' },
            { progress: 80, status: 'Initializing dashboard...' },
            { progress: 100, status: 'Almost ready!' }
        ];

        let currentStep = 0;
        
        const updateProgress = () => {
            if (currentStep < loadingSteps.length) {
                const step = loadingSteps[currentStep];
                progressBar.style.width = step.progress + '%';
                statusText.textContent = step.status;
                currentStep++;
                
                setTimeout(updateProgress, 300 + Math.random() * 400);
            } else {
                // Auto-hide after loading complete
                setTimeout(() => {
                    this.hide();
                }, 500);
            }
        };

        updateProgress();
    }

    updateProgress(percent, status) {
        const progressBar = document.getElementById('loading-progress-bar');
        const statusText = document.getElementById('loading-status');
        
        if (progressBar) {
            progressBar.style.width = percent + '%';
        }
        
        if (statusText && status) {
            statusText.textContent = status;
        }
    }
}

// Auto-initialize preloader
document.addEventListener('DOMContentLoaded', () => {
    window.ksoPreloader = new KSOPreloader();
});
