<?php
require_once 'config/database.php';
require_once 'config/auth_enhanced.php';

requireAdmin();

// Check if event ID is provided
if (!isset($_GET['id']) || empty($_GET['id'])) {
    header('Location: events.php');
    exit;
}

$eventId = (int)$_GET['id'];

require_once 'templates/header.php';
require_once 'templates/navbar.php';
require_once 'templates/sidebar.php';
?>

<!-- Content Wrapper -->
<div class="content-wrapper">
    <!-- Content Header -->
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">Event Details</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="index.php">Home</a></li>
                        <li class="breadcrumb-item"><a href="events.php">Events</a></li>
                        <li class="breadcrumb-item active">Event Details</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>

    <!-- Main content -->
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-12">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title" id="eventTitle">Loading Event...</h3>
                            <div class="card-tools">
                                <button type="button" class="btn btn-warning" id="editEventBtn">
                                    <i class="fas fa-edit"></i> Edit Event
                                </button>
                                <button type="button" class="btn btn-info" id="viewRegistrationsBtn">
                                    <i class="fas fa-users"></i> View Registrations
                                </button>
                            </div>
                        </div>
                        <div class="card-body">
                            <!-- Event details will be loaded here -->
                            <div class="overlay" id="eventLoader">
                                <i class="fas fa-sync fa-spin"></i>
                            </div>
                            <div id="eventDetails" style="display:none;">
                                <div class="row">
                                    <div class="col-md-4">
                                        <div class="card">
                                            <div class="card-body text-center" id="eventBannerContainer">
                                                <img id="eventBanner" class="img-fluid" src="dist/img/default-event.jpg" alt="Event Banner">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-8">
                                        <div class="info-box bg-light">
                                            <div class="info-box-content">
                                                <h5><i class="fas fa-calendar-alt mr-2"></i>Date:</h5>
                                                <p id="eventDate">Loading...</p>
                                                
                                                <h5><i class="fas fa-clock mr-2"></i>Time:</h5>
                                                <p id="eventTime">Loading...</p>
                                                
                                                <h5><i class="fas fa-map-marker-alt mr-2"></i>Location:</h5>
                                                <p id="eventLocation">Loading...</p>
                                                
                                                <h5><i class="fas fa-tag mr-2"></i>Type:</h5>
                                                <p id="eventType">Loading...</p>
                                                
                                                <h5><i class="fas fa-users mr-2"></i>Max Participants:</h5>
                                                <p id="eventMaxParticipants">Loading...</p>
                                                
                                                <h5><i class="fas fa-rupee-sign mr-2"></i>Registration Fee:</h5>
                                                <p id="eventFee">Loading...</p>
                                                
                                                <h5><i class="fas fa-info-circle mr-2"></i>Status:</h5>
                                                <p id="eventStatus">Loading...</p>
                                                
                                                <h5><i class="fas fa-user-check mr-2"></i>Registrations:</h5>
                                                <p id="eventRegistrations">Loading...</p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row mt-4">
                                    <div class="col-12">
                                        <div class="card">
                                            <div class="card-header">
                                                <h3 class="card-title">Event Description</h3>
                                            </div>
                                            <div class="card-body">
                                                <div id="eventDescription">Loading...</div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<script>
$(document).ready(function() {
    const eventId = <?php echo $eventId; ?>;
    
    // Load event details
    $.ajax({
        url: 'api/get_event.php',
        type: 'GET',
        data: { id: eventId },
        success: function(response) {
            if (response.success) {
                const event = response.data;
                
                // Update page title
                $('#eventTitle').text(event.event_title);
                
                // Set event details
                $('#eventDate').text(event.event_date);
                $('#eventTime').text(event.event_time || 'Not specified');
                $('#eventLocation').text(event.event_location || 'Not specified');
                $('#eventType').text(event.event_type);
                $('#eventMaxParticipants').text(event.max_participants || 'No limit');
                $('#eventFee').text('₹' + parseFloat(event.registration_fee).toFixed(2));
                
                // Set status with badge
                const statusBadges = {
                    'upcoming': 'info',
                    'ongoing': 'warning',
                    'completed': 'success',
                    'cancelled': 'danger'
                };
                $('#eventStatus').html(`<span class="badge badge-${statusBadges[event.status] || 'secondary'}">${event.status}</span>`);
                
                // Set registrations
                const maxParticipants = event.max_participants || 'No limit';
                $('#eventRegistrations').text(`${event.registration_count} / ${maxParticipants}`);
                
                // Set description
                $('#eventDescription').html(event.event_description || 'No description provided.');
                
                // Set banner if available
                if (event.event_banner_url) {
                    $('#eventBanner').attr('src', event.event_banner_url);
                }
                
                // Setup buttons
                $('#editEventBtn').click(function() {
                    window.location.href = 'edit-event.php?id=' + eventId;
                });
                
                $('#viewRegistrationsBtn').click(function() {
                    window.location.href = 'event-registrations.php?id=' + eventId;
                });
                
                // Show details and hide loader
                $('#eventLoader').hide();
                $('#eventDetails').show();
            } else {
                toastr.error(response.message || 'Failed to load event details');
                $('#eventLoader').html('<div class="text-center"><h4>Event not found</h4><p>The requested event could not be loaded.</p></div>');
            }
        },
        error: function() {
            toastr.error('Error loading event details');
            $('#eventLoader').html('<div class="text-center"><h4>Error</h4><p>Failed to load event details. Please try again.</p></div>');
        }
    });
});
</script>

<?php require_once 'templates/footer.php'; ?>
