<?php
/**
 * Sample Reminder Email Templates
 * 
 * This file contains HTML templates for reminder emails
 */

// Upcoming due assignment reminder template
function getUpcomingDueTemplate($adminName, $memberName, $assignmentId, $assignmentTitle, $dueDate, $siteName, $siteUrl) {
    $formattedDueDate = date('F j, Y, g:i a', strtotime($dueDate));
    
    return <<<HTML
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Assignment Due Soon</title>
    <style>
        body { font-family: Arial, sans-serif; line-height: 1.6; color: #333; }
        .container { max-width: 600px; margin: 0 auto; padding: 20px; }
        .header { background-color: #3c8dbc; color: white; padding: 10px 20px; }
        .content { padding: 20px; border: 1px solid #ddd; }
        .footer { font-size: 12px; color: #777; margin-top: 20px; text-align: center; }
        .button { display: inline-block; background-color: #3c8dbc; color: white; text-decoration: none; padding: 10px 20px; border-radius: 4px; }
        .highlight { color: #dd4b39; font-weight: bold; }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h2>Assignment Due Soon</h2>
        </div>
        <div class="content">
            <p>Dear $adminName,</p>
            
            <p>This is a friendly reminder that you have an assignment that is <span class="highlight">due soon</span>:</p>
            
            <p><strong>Assignment ID:</strong> #$assignmentId<br>
            <strong>Title:</strong> $assignmentTitle<br>
            <strong>Member:</strong> $memberName<br>
            <strong>Due Date:</strong> $formattedDueDate</p>
            
            <p>Please complete this assignment before the due date to ensure timely processing.</p>
            
            <p style="text-align: center; margin: 30px 0;">
                <a href="$siteUrl/adminlte/assignments.php?id=$assignmentId" class="button">View Assignment</a>
            </p>
            
            <p>Thank you for your attention to this matter.</p>
            
            <p>Regards,<br>$siteName Team</p>
        </div>
        <div class="footer">
            <p>This is an automated message from $siteName. Please do not reply to this email.</p>
        </div>
    </div>
</body>
</html>
HTML;
}

// Overdue assignment reminder template
function getOverdueTemplate($adminName, $memberName, $assignmentId, $assignmentTitle, $dueDate, $daysOverdue, $siteName, $siteUrl) {
    $formattedDueDate = date('F j, Y, g:i a', strtotime($dueDate));
    
    return <<<HTML
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Overdue Assignment</title>
    <style>
        body { font-family: Arial, sans-serif; line-height: 1.6; color: #333; }
        .container { max-width: 600px; margin: 0 auto; padding: 20px; }
        .header { background-color: #dd4b39; color: white; padding: 10px 20px; }
        .content { padding: 20px; border: 1px solid #ddd; }
        .footer { font-size: 12px; color: #777; margin-top: 20px; text-align: center; }
        .button { display: inline-block; background-color: #dd4b39; color: white; text-decoration: none; padding: 10px 20px; border-radius: 4px; }
        .highlight { color: #dd4b39; font-weight: bold; }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h2>Overdue Assignment</h2>
        </div>
        <div class="content">
            <p>Dear $adminName,</p>
            
            <p>This is an important reminder that you have an assignment that is <span class="highlight">$daysOverdue days overdue</span>:</p>
            
            <p><strong>Assignment ID:</strong> #$assignmentId<br>
            <strong>Title:</strong> $assignmentTitle<br>
            <strong>Member:</strong> $memberName<br>
            <strong>Due Date:</strong> $formattedDueDate<br>
            <strong>Status:</strong> <span class="highlight">OVERDUE by $daysOverdue days</span></p>
            
            <p>Please attend to this assignment as soon as possible to avoid further delays.</p>
            
            <p style="text-align: center; margin: 30px 0;">
                <a href="$siteUrl/adminlte/assignments.php?id=$assignmentId" class="button">View Assignment</a>
            </p>
            
            <p>If you are unable to complete this assignment, please update its status or contact your supervisor.</p>
            
            <p>Thank you for your immediate attention to this matter.</p>
            
            <p>Regards,<br>$siteName Team</p>
        </div>
        <div class="footer">
            <p>This is an automated message from $siteName. Please do not reply to this email.</p>
        </div>
    </div>
</body>
</html>
HTML;
}

// Inactive assignment reminder template
function getInactiveTemplate($adminName, $memberName, $assignmentId, $assignmentTitle, $dueDate, $siteName, $siteUrl) {
    $formattedDueDate = date('F j, Y, g:i a', strtotime($dueDate));
    
    return <<<HTML
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Inactive Assignment</title>
    <style>
        body { font-family: Arial, sans-serif; line-height: 1.6; color: #333; }
        .container { max-width: 600px; margin: 0 auto; padding: 20px; }
        .header { background-color: #f39c12; color: white; padding: 10px 20px; }
        .content { padding: 20px; border: 1px solid #ddd; }
        .footer { font-size: 12px; color: #777; margin-top: 20px; text-align: center; }
        .button { display: inline-block; background-color: #f39c12; color: white; text-decoration: none; padding: 10px 20px; border-radius: 4px; }
        .highlight { color: #f39c12; font-weight: bold; }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h2>Inactive Assignment</h2>
        </div>
        <div class="content">
            <p>Dear $adminName,</p>
            
            <p>We've noticed that you have an assignment with <span class="highlight">no activity for over 7 days</span>:</p>
            
            <p><strong>Assignment ID:</strong> #$assignmentId<br>
            <strong>Title:</strong> $assignmentTitle<br>
            <strong>Member:</strong> $memberName<br>
            <strong>Due Date:</strong> $formattedDueDate</p>
            
            <p>Please either update the status of this assignment or take the necessary action to progress it.</p>
            
            <p style="text-align: center; margin: 30px 0;">
                <a href="$siteUrl/adminlte/assignments.php?id=$assignmentId" class="button">View Assignment</a>
            </p>
            
            <p>If you are unable to complete this assignment, please update its status or contact your supervisor.</p>
            
            <p>Thank you for your attention to this matter.</p>
            
            <p>Regards,<br>$siteName Team</p>
        </div>
        <div class="footer">
            <p>This is an automated message from $siteName. Please do not reply to this email.</p>
        </div>
    </div>
</body>
</html>
HTML;
}

// Supervisor escalation template
function getSupervisorEscalationTemplate($supervisorName, $adminName, $memberName, $assignmentId, $assignmentTitle, $dueDate, $siteName, $siteUrl) {
    $formattedDueDate = date('F j, Y, g:i a', strtotime($dueDate));
    
    return <<<HTML
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Assignment Escalation Notice</title>
    <style>
        body { font-family: Arial, sans-serif; line-height: 1.6; color: #333; }
        .container { max-width: 600px; margin: 0 auto; padding: 20px; }
        .header { background-color: #605ca8; color: white; padding: 10px 20px; }
        .content { padding: 20px; border: 1px solid #ddd; }
        .footer { font-size: 12px; color: #777; margin-top: 20px; text-align: center; }
        .button { display: inline-block; background-color: #605ca8; color: white; text-decoration: none; padding: 10px 20px; border-radius: 4px; }
        .highlight { color: #605ca8; font-weight: bold; }
        .admin-name { color: #dd4b39; font-weight: bold; }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h2>Assignment Escalation Notice</h2>
        </div>
        <div class="content">
            <p>Dear $supervisorName,</p>
            
            <p>This is to inform you that an assignment assigned to <span class="admin-name">$adminName</span> has been <span class="highlight">inactive for over 14 days</span>:</p>
            
            <p><strong>Assignment ID:</strong> #$assignmentId<br>
            <strong>Title:</strong> $assignmentTitle<br>
            <strong>Member:</strong> $memberName<br>
            <strong>Assigned To:</strong> $adminName<br>
            <strong>Due Date:</strong> $formattedDueDate<br>
            <strong>Status:</strong> <span class="highlight">Inactive (14+ days)</span></p>
            
            <p>This assignment may require your attention or intervention to ensure it is completed in a timely manner.</p>
            
            <p style="text-align: center; margin: 30px 0;">
                <a href="$siteUrl/adminlte/assignments.php?id=$assignmentId" class="button">View Assignment</a>
            </p>
            
            <p>Please follow up with $adminName regarding this assignment or reassign it if necessary.</p>
            
            <p>Thank you for your attention to this matter.</p>
            
            <p>Regards,<br>$siteName Team</p>
        </div>
        <div class="footer">
            <p>This is an automated message from $siteName. Please do not reply to this email.</p>
        </div>
    </div>
</body>
</html>
HTML;
}
