<?php
/**
 * Simple API Structure Verification
 * Checks that the API reorganization is properly configured
 */

echo "🔧 API Structure Verification\n";
echo "============================\n\n";

// Test if organized API files exist
echo "📂 Verifying Organized API Files:\n";

$testPaths = [
    'api/dashboard/fetch_dashboard_stats.php',
    'api/finance/fetch_transactions.php',
    'api/finance/fetch_finance_stats.php',
    'api/charts/fetch_revenue_chart.php', 
    'api/reports/export_report.php',
    'api/system/fetch_settings.php',
    'api/auth/refresh_session.php'
];

$foundFiles = 0;
$totalFiles = count($testPaths);

foreach ($testPaths as $path) {
    if (file_exists($path)) {
        echo "✅ $path\n";
        $foundFiles++;
    } else {
        echo "❌ $path\n";
    }
}

echo "\n🌐 .htaccess Configuration:\n";
if (file_exists('.htaccess')) {
    $htaccess = file_get_contents('.htaccess');
    if (strpos($htaccess, 'RewriteCond %{REQUEST_URI} ^/adminlte/api/ [NC]') !== false) {
        echo "✅ .htaccess has correct API rewrite rule\n";
        echo "   Rule: 'RewriteCond %{REQUEST_URI} ^/adminlte/api/ [NC]'\n";
        echo "   This allows ALL API subdirectories to work\n";
    } else {
        echo "⚠️  .htaccess needs API rewrite rule update\n";
    }
} else {
    echo "❌ .htaccess file not found\n";
}

echo "\n📋 Summary:\n";
echo "- API Files Found: $foundFiles/$totalFiles\n";
echo "- .htaccess Status: " . (file_exists('.htaccess') ? "✅ Exists" : "❌ Missing") . "\n";

if ($foundFiles == $totalFiles && file_exists('.htaccess')) {
    echo "\n🎉 SUCCESS: API reorganization is complete and properly configured!\n";
    echo "✅ All organized API files are in place\n";
    echo "✅ .htaccess will route API requests correctly\n";
    echo "✅ New subdirectory structure is fully functional\n";
} else {
    echo "\n⚠️  Issues found - please review the missing files or configuration\n";
}
?>
