<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

// Mock data for enhanced dashboard
$mockData = [
    'stats' => [
        'totalMembers' => 267,
        'activeMembers' => 245,
        'pendingApprovals' => 5,
        'totalEvents' => 18,
        'activeEvents' => 12,
        'totalIncome' => 52500,
        'totalExpenses' => 15000,
        'netBalance' => 37500
    ],
    'charts' => [
        'memberGrowth' => [
            'labels' => ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun'],
            'data' => [15, 23, 18, 27, 22, 35]
        ],
        'eventAttendance' => [
            'labels' => ['Cultural Night', 'Sports Day', 'Tech Fest', 'Annual Meet'],
            'data' => [85, 92, 78, 88]
        ]
    ],
    'activities' => [
        [
            'id' => 1,
            'title' => 'New Member Registration',
            'description' => 'Priya Sharma registered as a new member',
            'type' => 'success',
            'icon' => 'fas fa-user-plus',
            'time' => '2 minutes ago',
            'date' => date('Y-m-d H:i:s'),
            'user' => [
                'name' => 'Registration System',
                'avatar' => 'dist/img/user-placeholder.png'
            ]
        ],
        [
            'id' => 2,
            'title' => 'Event Registration Opened',
            'description' => 'Winter Festival 2024 registration is now open',
            'type' => 'info',
            'icon' => 'fas fa-calendar-alt',
            'time' => '1 hour ago',
            'date' => date('Y-m-d H:i:s', strtotime('-1 hour')),
            'user' => [
                'name' => 'Event Manager',
                'avatar' => 'dist/img/user-placeholder.png'
            ]
        ],
        [
            'id' => 3,
            'title' => 'Payment Received',
            'description' => 'Membership fee payment of ₹1,500 received from Raj Kumar',
            'type' => 'success',
            'icon' => 'fas fa-credit-card',
            'time' => '3 hours ago',
            'date' => date('Y-m-d H:i:s', strtotime('-3 hours')),
            'user' => [
                'name' => 'Finance Team',
                'avatar' => 'dist/img/user-placeholder.png'
            ]
        ],
        [
            'id' => 4,
            'title' => 'Document Approval Pending',
            'description' => '3 member documents are pending approval',
            'type' => 'warning',
            'icon' => 'fas fa-exclamation-triangle',
            'time' => '5 hours ago',
            'date' => date('Y-m-d H:i:s', strtotime('-5 hours')),
            'user' => [
                'name' => 'Admin System',
                'avatar' => 'dist/img/user-placeholder.png'
            ]
        ],
        [
            'id' => 5,
            'title' => 'System Backup Completed',
            'description' => 'Daily system backup completed successfully',
            'type' => 'success',
            'icon' => 'fas fa-database',
            'time' => '1 day ago',
            'date' => date('Y-m-d H:i:s', strtotime('-1 day')),
            'user' => [
                'name' => 'System',
                'avatar' => 'dist/img/user-placeholder.png'
            ]
        ]
    ],
    'progress' => [
        [
            'label' => 'Membership Goal (300 members)',
            'value' => 89,
            'color' => '#28a745'
        ],
        [
            'label' => 'Event Attendance Rate',
            'value' => 76,
            'color' => '#007bff'
        ],
        [
            'label' => 'Fee Collection Rate',
            'value' => 92,
            'color' => '#ffc107'
        ],
        [
            'label' => 'Document Processing',
            'value' => 68,
            'color' => '#dc3545'
        ]
    ],
    'notifications' => [
        [
            'id' => 1,
            'type' => 'info',
            'title' => 'System Update',
            'message' => 'New features have been added to the dashboard',
            'timestamp' => date('Y-m-d H:i:s')
        ],
        [
            'id' => 2,
            'type' => 'warning',
            'title' => 'Payment Reminder',
            'message' => '25 members have pending fee payments',
            'timestamp' => date('Y-m-d H:i:s', strtotime('-2 hours'))
        ],
        [
            'id' => 3,
            'type' => 'success',
            'title' => 'Event Success',
            'message' => 'Cultural Night 2024 was successfully completed',
            'timestamp' => date('Y-m-d H:i:s', strtotime('-1 day'))
        ]
    ]
];

// Handle different API endpoints
$endpoint = $_GET['endpoint'] ?? 'all';

switch ($endpoint) {
    case 'stats':
        echo json_encode([
            'success' => true,
            'data' => $mockData['stats']
        ]);
        break;
        
    case 'charts':
        echo json_encode([
            'success' => true,
            'data' => $mockData['charts']
        ]);
        break;
        
    case 'activities':
        echo json_encode([
            'success' => true,
            'data' => $mockData['activities']
        ]);
        break;
        
    case 'progress':
        echo json_encode([
            'success' => true,
            'data' => $mockData['progress']
        ]);
        break;
        
    case 'notifications':
        echo json_encode([
            'success' => true,
            'data' => $mockData['notifications']
        ]);
        break;
        
    case 'all':
    default:
        echo json_encode([
            'success' => true,
            'data' => $mockData
        ]);
        break;
}
?>
