<?php
require_once '../config/database.php';

header('Content-Type: application/json');

try {
    $pdo = getDBConnection();

    $stmt = $pdo->query("
        SELECT id, event_title, event_description, event_date, event_time, 
               event_location, event_type, max_participants, registration_fee, 
               status, created_at 
        FROM events 
        ORDER BY event_date DESC
    ");
    $events = $stmt->fetchAll();

    echo json_encode(['success' => true, 'data' => $events]);
} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
}
?>
