<?php
require_once '../config.php';
require_once '../auth/check_auth.php';

if (!isset($_SESSION['admin_id'])) {
    header('Location: ../login.php');
    exit();
}

$card_id = $_GET['id'] ?? null;

if (!$card_id) {
    die('Card ID not provided');
}

try {
    // Get card details
    $stmt = $pdo->prepare("
        SELECT 
            ic.*,
            m.first_name,
            m.last_name,
            m.kso_id,
            m.photo_url,
            m.membership_type,
            CONCAT(m.first_name, ' ', m.last_name) as member_name
        FROM id_cards ic
        LEFT JOIN members m ON ic.member_id = m.id
        WHERE ic.id = ?
    ");
    
    $stmt->execute([$card_id]);
    $card = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$card) {
        die('Card not found');
    }
    
    // Check if file exists
    if ($card['file_path'] && file_exists('../../../' . $card['file_path'])) {
        // Serve existing file
        $file_path = '../../../' . $card['file_path'];
        $file_info = pathinfo($file_path);
        
        if ($file_info['extension'] === 'pdf') {
            header('Content-Type: application/pdf');
        } else {
            header('Content-Type: text/html');
        }
        
        readfile($file_path);
    } else {
        // Generate card HTML on the fly
        $card_html = generateCardHTML($card);
        echo $card_html;
    }
    
} catch (Exception $e) {
    error_log("Card View Error: " . $e->getMessage());
    die('Error loading card: ' . $e->getMessage());
}

function generateCardHTML($card) {
    $member_name = $card['member_name'];
    $photo_url = $card['photo_url'] ?? 'dist/img/default-user.png';
    
    $qr_code_html = $card['qr_code_included'] ? "<div class='qr-code'><i class='fas fa-qrcode'></i></div>" : '';
    
    return "
    <!DOCTYPE html>
    <html>
    <head>
        <meta charset='utf-8'>
        <title>ID Card - {$member_name}</title>
        <link rel='stylesheet' href='https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css'>
        <style>
            body { 
                margin: 0; 
                padding: 20px; 
                font-family: Arial, sans-serif; 
                background: #f5f5f5;
                display: flex;
                justify-content: center;
                align-items: center;
                min-height: 100vh;
            }
            .id-card {
                width: 320px;
                height: 200px;
                background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
                border-radius: 15px;
                padding: 20px;
                color: white;
                position: relative;
                box-shadow: 0 8px 25px rgba(0,0,0,0.15);
            }
            .card-header {
                text-align: center;
                font-size: 12px;
                font-weight: bold;
                margin-bottom: 10px;
            }
            .member-info {
                display: flex;
                align-items: center;
                gap: 15px;
            }
            .member-photo {
                width: 60px;
                height: 60px;
                border-radius: 50%;
                background: #fff;
                display: flex;
                align-items: center;
                justify-content: center;
                font-size: 24px;
                color: #667eea;
            }
            .member-details {
                flex: 1;
            }
            .member-name {
                font-size: 16px;
                font-weight: bold;
                margin-bottom: 5px;
            }
            .member-id {
                font-size: 12px;
                opacity: 0.9;
            }
            .card-footer {
                position: absolute;
                bottom: 10px;
                right: 15px;
                font-size: 10px;
                opacity: 0.8;
            }
            .qr-code {
                position: absolute;
                bottom: 10px;
                left: 15px;
                width: 30px;
                height: 30px;
                background: white;
                border-radius: 4px;
                display: flex;
                align-items: center;
                justify-content: center;
                font-size: 12px;
                color: #333;
            }
            .card-actions {
                text-align: center;
                margin-top: 20px;
            }
            .btn {
                padding: 10px 20px;
                margin: 0 10px;
                border: none;
                border-radius: 5px;
                cursor: pointer;
                text-decoration: none;
                display: inline-block;
                font-size: 14px;
            }
            .btn-primary {
                background: #007bff;
                color: white;
            }
            .btn-success {
                background: #28a745;
                color: white;
            }
            .btn:hover {
                opacity: 0.9;
            }
            @media print {
                .card-actions { display: none; }
                body { background: white; }
            }
        </style>
    </head>
    <body>
        <div class='container'>
            <div class='id-card'>
                <div class='card-header'>
                    KASHMIRI STUDENTS ORGANIZATION<br>
                    CHANDIGARH
                </div>
                <div class='member-info'>
                    <div class='member-photo'>
                        <i class='fas fa-user'></i>
                    </div>
                    <div class='member-details'>
                        <div class='member-name'>{$member_name}</div>
                        <div class='member-id'>ID: {$card['kso_id']}</div>
                        <div class='member-id'>Card: {$card['card_number']}</div>
                        <div class='member-id'>Type: " . ucfirst(str_replace('_', ' ', $card['card_type'])) . "</div>
                    </div>
                </div>
                {$qr_code_html}
                <div class='card-footer'>
                    Valid Until: " . date('M Y', strtotime($card['expiry_date'])) . "
                </div>
            </div>
            
            <div class='card-actions'>
                <a href='download.php?id={$card['id']}' class='btn btn-success'>
                    <i class='fas fa-download'></i> Download
                </a>
                <button onclick='window.print()' class='btn btn-primary'>
                    <i class='fas fa-print'></i> Print
                </button>
            </div>
        </div>
    </body>
    </html>";
}
?>
