<?php
// Database configuration
define('DB_HOST', 'localhost');
define('DB_NAME', 'ktxmmosu_kso_chandigarh');
define('DB_USER', 'root');
define('DB_PASS', '');

// Error reporting
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Session configuration
session_start();

// Global PDO connection
$pdo = null;

// Database connection function
function getDBConnection() {
    global $pdo;
    
    if ($pdo === null) {
        try {
            $pdo = new PDO(
                "mysql:host=" . DB_HOST . ";dbname=" . DB_NAME . ";charset=utf8mb4",
                DB_USER,
                DB_PASS,
                [
                    PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
                    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
                    PDO::ATTR_EMULATE_PREPARES => false,
                    PDO::ATTR_TIMEOUT => 30,
                    PDO::MYSQL_ATTR_INIT_COMMAND => "SET NAMES utf8mb4"
                ]
            );
        } catch (PDOException $e) {
            error_log("Database connection error: " . $e->getMessage());
            die("Database connection failed: " . $e->getMessage());
        }
    }
    
    return $pdo;
}

// Initialize database connection
$pdo = getDBConnection();

// Include enhanced authentication
require_once 'auth_enhanced.php';

// Legacy compatibility functions
function requireLogin() {
    requireAdmin();
}

// Check if user is logged in
function isLoggedIn() {
    return checkAuthentication();
}

// Get current admin info
function getCurrentAdmin() {
    if (!isLoggedIn()) {
        return null;
    }
    
    return [
        'id' => $_SESSION['admin_id'],
        'username' => $_SESSION['admin_username'],
        'role' => $_SESSION['admin_role'],
        'name' => $_SESSION['admin_name'],
        'permissions' => $_SESSION['admin_permissions'] ?? []
    ];
}

// Check if current user has specific role
function hasRole($role) {
    return isset($_SESSION['admin_role']) && $_SESSION['admin_role'] === $role;
}
?>
