<?php
require_once 'config/database.php';
requireAdmin(); // Ensure only admins can access this page

require_once 'templates/header.php';
require_once 'templates/navbar.php';
require_once 'templates/sidebar.php';
?>

<!-- Content Wrapper -->
<div class="content-wrapper">
    <!-- Content Header -->
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">Dashboard</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="#">Home</a></li>
                        <li class="breadcrumb-item active">Dashboard</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>

    <!-- Main content -->
    <section class="content">
        <div class="container-fluid">
            <!-- Small boxes (Stat box) -->
            <div class="row">
                <div class="col-lg-3 col-6">
                    <!-- small box -->
                    <div class="small-box bg-info">
                        <div class="inner">
                            <h3 id="totalMembers">0</h3>
                            <p>Total Members</p>
                        </div>
                        <div class="icon">
                            <i class="ion ion-person-add"></i>
                        </div>
                        <a href="members.php" class="small-box-footer">More info <i class="fas fa-arrow-circle-right"></i></a>
                    </div>
                </div>
                <!-- ./col -->
                <div class="col-lg-3 col-6">
                    <!-- small box -->
                    <div class="small-box bg-success">
                        <div class="inner">
                            <h3 id="totalEvents">0</h3>
                            <p>Total Events</p>
                        </div>
                        <div class="icon">
                            <i class="ion ion-calendar"></i>
                        </div>
                        <a href="events.php" class="small-box-footer">More info <i class="fas fa-arrow-circle-right"></i></a>
                    </div>
                </div>
                <!-- ./col -->
                <div class="col-lg-3 col-6">
                    <!-- small box -->
                    <div class="small-box bg-warning">
                        <div class="inner">
                            <h3 id="totalIncome">₹0</h3>
                            <p>Total Income</p>
                        </div>
                        <div class="icon">
                            <i class="ion ion-cash"></i>
                        </div>
                        <a href="finance.php" class="small-box-footer">More info <i class="fas fa-arrow-circle-right"></i></a>
                    </div>
                </div>
                <!-- ./col -->
                <div class="col-lg-3 col-6">
                    <!-- small box -->
                    <div class="small-box bg-danger">
                        <div class="inner">
                            <h3 id="pendingApprovals">0</h3>
                            <p>Pending Approvals</p>
                        </div>
                        <div class="icon">
                            <i class="ion ion-clock"></i>
                        </div>
                        <a href="member-approval.php" class="small-box-footer">More info <i class="fas fa-arrow-circle-right"></i></a>
                    </div>
                </div>
                <!-- ./col -->
            </div>
        </div>
    </section>

    <!-- Activity Logs Section -->
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">Recent Activity Logs</h3>
                        </div>
                        <!-- /.card-header -->
                        <div class="card-body">
                            <table id="activityLogs" class="table table-bordered table-striped">
                                <thead>
                                    <tr>
                                        <th>ID</th>
                                        <th>User ID</th>
                                        <th>Action</th>
                                        <th>Details</th>
                                        <th>IP Address</th>
                                        <th>Created At</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <!-- Data will be populated via AJAX -->
                                </tbody>
                            </table>
                        </div>
                        <!-- /.card-body -->
                    </div>
                    <!-- /.card -->
                </div>
            </div>
        </div>
    </section>

    <script>
        document.addEventListener('DOMContentLoaded', function () {
            // Fetch dashboard statistics
            fetch('api/fetch_dashboard_stats.php')
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        const stats = data.data;
                        
                        // Update stat boxes
                        document.getElementById('totalMembers').textContent = stats.members.total_members;
                        document.getElementById('totalEvents').textContent = stats.events.total_events;
                        document.getElementById('totalIncome').textContent = '₹' + parseFloat(stats.finance.total_income).toLocaleString();
                        document.getElementById('pendingApprovals').textContent = stats.members.pending_members;
                    } else {
                        console.error('Failed to fetch stats:', data.message);
                    }
                })
                .catch(error => console.error('Error fetching stats:', error));

            // Fetch activity logs
            fetch('api/fetch_activity_logs.php')
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        const tbody = document.querySelector('#activityLogs tbody');
                        tbody.innerHTML = ''; // Clear existing content
                        
                        if (data.data && data.data.length > 0) {
                            data.data.forEach(log => {
                                const row = document.createElement('tr');
                                row.innerHTML = `
                                    <td>${log.id}</td>
                                    <td>${log.user_id || 'N/A'}</td>
                                    <td>${log.action}</td>
                                    <td>${log.details || 'N/A'}</td>
                                    <td>${log.ip_address || 'N/A'}</td>
                                    <td>${log.created_at}</td>
                                `;
                                tbody.appendChild(row);
                            });
                        } else {
                            tbody.innerHTML = '<tr><td colspan="6" class="text-center">No activity logs found</td></tr>';
                        }
                    } else {
                        console.error('Failed to fetch logs:', data.message);
                        document.querySelector('#activityLogs tbody').innerHTML = 
                            '<tr><td colspan="6" class="text-center text-danger">Error loading logs</td></tr>';
                    }
                })
                .catch(error => {
                    console.error('Error fetching logs:', error);
                    document.querySelector('#activityLogs tbody').innerHTML = 
                        '<tr><td colspan="6" class="text-center text-danger">Network error</td></tr>';
                });
        });
    </script>
</div>

<?php
require_once 'templates/footer.php';
?>
