<?php
require_once 'config/database.php';
requireAdmin();

require_once 'templates/header.php';
require_once 'templates/navbar.php';
require_once 'templates/sidebar.php';
?>

<!-- Content Wrapper -->
<div class="content-wrapper">
    <!-- Content Header -->
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">Member Registration</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="index.php">Home</a></li>
                        <li class="breadcrumb-item"><a href="members.php">Members</a></li>
                        <li class="breadcrumb-item active">Registration</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>

    <!-- Main content -->
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">New Member Registration</h3>
                        </div>
                        <form id="memberRegistrationForm" enctype="multipart/form-data">
                            <div class="card-body">
                                <div class="row">
                                    <!-- Personal Information -->
                                    <div class="col-md-6">
                                        <h4>Personal Information</h4>
                                        <div class="form-group">
                                            <label>First Name *</label>
                                            <input type="text" class="form-control" name="first_name" required>
                                        </div>
                                        <div class="form-group">
                                            <label>Last Name *</label>
                                            <input type="text" class="form-control" name="last_name" required>
                                        </div>
                                        <div class="form-group">
                                            <label>Father's Name</label>
                                            <input type="text" class="form-control" name="father_name">
                                        </div>
                                        <div class="form-group">
                                            <label>Date of Birth *</label>
                                            <input type="date" class="form-control" name="date_of_birth" required>
                                        </div>
                                        <div class="form-group">
                                            <label>Gender *</label>
                                            <select class="form-control" name="gender" required>
                                                <option value="">Select Gender</option>
                                                <option value="male">Male</option>
                                                <option value="female">Female</option>
                                                <option value="other">Other</option>
                                            </select>
                                        </div>
                                        <div class="form-group">
                                            <label>Marital Status</label>
                                            <select class="form-control" name="marital_status">
                                                <option value="">Select Status</option>
                                                <option value="single">Single</option>
                                                <option value="married">Married</option>
                                                <option value="divorced">Divorced</option>
                                                <option value="widowed">Widowed</option>
                                            </select>
                                        </div>
                                    </div>

                                    <!-- Contact Information -->
                                    <div class="col-md-6">
                                        <h4>Contact Information</h4>
                                        <div class="form-group">
                                            <label>Phone Number *</label>
                                            <input type="tel" class="form-control" name="phone" required>
                                        </div>
                                        <div class="form-group">
                                            <label>Email Address *</label>
                                            <input type="email" class="form-control" name="email" required>
                                        </div>
                                        <div class="form-group">
                                            <label>Address *</label>
                                            <textarea class="form-control" name="address" rows="3" required></textarea>
                                        </div>
                                        <div class="form-group">
                                            <label>City *</label>
                                            <input type="text" class="form-control" name="city" required>
                                        </div>
                                        <div class="form-group">
                                            <label>State *</label>
                                            <input type="text" class="form-control" name="state" required>
                                        </div>
                                        <div class="form-group">
                                            <label>PIN Code *</label>
                                            <input type="text" class="form-control" name="pin_code" required>
                                        </div>
                                    </div>
                                </div>

                                <hr>

                                <div class="row">
                                    <!-- Professional Information -->
                                    <div class="col-md-6">
                                        <h4>Professional Information</h4>
                                        <div class="form-group">
                                            <label>Occupation</label>
                                            <input type="text" class="form-control" name="occupation">
                                        </div>
                                        <div class="form-group">
                                            <label>Organization</label>
                                            <input type="text" class="form-control" name="organization">
                                        </div>
                                        <div class="form-group">
                                            <label>Designation</label>
                                            <input type="text" class="form-control" name="designation">
                                        </div>
                                        <div class="form-group">
                                            <label>Annual Income</label>
                                            <input type="number" class="form-control" name="annual_income">
                                        </div>
                                    </div>

                                    <!-- Educational Information -->
                                    <div class="col-md-6">
                                        <h4>Educational Information</h4>
                                        <div class="form-group">
                                            <label>Education Level</label>
                                            <select class="form-control" name="education_level">
                                                <option value="">Select Level</option>
                                                <option value="high_school">High School</option>
                                                <option value="diploma">Diploma</option>
                                                <option value="bachelor">Bachelor's Degree</option>
                                                <option value="master">Master's Degree</option>
                                                <option value="doctorate">Doctorate</option>
                                                <option value="other">Other</option>
                                            </select>
                                        </div>
                                        <div class="form-group">
                                            <label>Field of Study</label>
                                            <input type="text" class="form-control" name="field_of_study">
                                        </div>
                                        <div class="form-group">
                                            <label>Institution</label>
                                            <input type="text" class="form-control" name="institution">
                                        </div>
                                        <div class="form-group">
                                            <label>Graduation Year</label>
                                            <input type="number" class="form-control" name="graduation_year" min="1950" max="2030">
                                        </div>
                                    </div>
                                </div>

                                <hr>

                                <div class="row">
                                    <!-- Membership Information -->
                                    <div class="col-md-6">
                                        <h4>Membership Information</h4>
                                        <div class="form-group">
                                            <label>Membership Type *</label>
                                            <select class="form-control" name="membership_type" required>
                                                <option value="">Select Type</option>
                                                <option value="individual">Individual</option>
                                                <option value="family">Family</option>
                                                <option value="student">Student</option>
                                                <option value="senior">Senior Citizen</option>
                                            </select>
                                        </div>
                                        <div class="form-group">
                                            <label>Membership Duration *</label>
                                            <select class="form-control" name="membership_duration" required>
                                                <option value="">Select Duration</option>
                                                <option value="1">1 Year</option>
                                                <option value="2">2 Years</option>
                                                <option value="3">3 Years</option>
                                                <option value="5">5 Years</option>
                                                <option value="lifetime">Lifetime</option>
                                            </select>
                                        </div>
                                        <div class="form-group">
                                            <label>Referral Source</label>
                                            <select class="form-control" name="referral_source">
                                                <option value="">Select Source</option>
                                                <option value="website">Website</option>
                                                <option value="friend">Friend/Family</option>
                                                <option value="social_media">Social Media</option>
                                                <option value="event">Event</option>
                                                <option value="other">Other</option>
                                            </select>
                                        </div>
                                    </div>

                                    <!-- Document Upload -->
                                    <div class="col-md-6">
                                        <h4>Document Upload</h4>
                                        <div class="form-group">
                                            <label>Profile Photo</label>
                                            <input type="file" class="form-control-file" name="profile_photo" accept="image/*">
                                            <small class="form-text text-muted">Max size: 2MB. Formats: JPG, PNG</small>
                                        </div>
                                        <div class="form-group">
                                            <label>ID Proof</label>
                                            <input type="file" class="form-control-file" name="id_proof" accept="image/*,.pdf">
                                            <small class="form-text text-muted">Aadhar/Passport/License. Max size: 5MB</small>
                                        </div>
                                        <div class="form-group">
                                            <label>Address Proof</label>
                                            <input type="file" class="form-control-file" name="address_proof" accept="image/*,.pdf">
                                            <small class="form-text text-muted">Utility Bill/Bank Statement. Max size: 5MB</small>
                                        </div>
                                    </div>
                                </div>

                                <hr>

                                <!-- Terms and Conditions -->
                                <div class="row">
                                    <div class="col-12">
                                        <div class="form-group">
                                            <div class="custom-control custom-checkbox">
                                                <input type="checkbox" class="custom-control-input" id="terms_accepted" name="terms_accepted" required>
                                                <label class="custom-control-label" for="terms_accepted">
                                                    I agree to the <a href="#" data-toggle="modal" data-target="#termsModal">Terms and Conditions</a>
                                                </label>
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <div class="custom-control custom-checkbox">
                                                <input type="checkbox" class="custom-control-input" id="privacy_accepted" name="privacy_accepted" required>
                                                <label class="custom-control-label" for="privacy_accepted">
                                                    I agree to the <a href="#" data-toggle="modal" data-target="#privacyModal">Privacy Policy</a>
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="card-footer">
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-save"></i> Register Member
                                </button>
                                <button type="reset" class="btn btn-secondary">
                                    <i class="fas fa-undo"></i> Reset Form
                                </button>
                                <a href="members.php" class="btn btn-default">
                                    <i class="fas fa-arrow-left"></i> Back to Members
                                </a>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<!-- Terms Modal -->
<div class="modal fade" id="termsModal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">Terms and Conditions</h4>
                <button type="button" class="close" data-dismiss="modal">&times;</button>
            </div>
            <div class="modal-body">
                <h5>1. Membership Terms</h5>
                <p>By becoming a member of KSO Chandigarh, you agree to abide by all organizational rules and regulations.</p>
                
                <h5>2. Membership Fees</h5>
                <p>Membership fees are non-refundable and must be paid in full at the time of registration.</p>
                
                <h5>3. Code of Conduct</h5>
                <p>All members must maintain respectful behavior and contribute positively to the community.</p>
                
                <h5>4. Privacy and Data Protection</h5>
                <p>Your personal information will be handled in accordance with our Privacy Policy.</p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>

<!-- Privacy Modal -->
<div class="modal fade" id="privacyModal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">Privacy Policy</h4>
                <button type="button" class="close" data-dismiss="modal">&times;</button>
            </div>
            <div class="modal-body">
                <h5>Information We Collect</h5>
                <p>We collect personal information necessary for membership registration and management.</p>
                
                <h5>How We Use Your Information</h5>
                <p>Your information is used for membership management, communication, and event organization.</p>
                
                <h5>Data Security</h5>
                <p>We implement appropriate security measures to protect your personal information.</p>
                
                <h5>Data Sharing</h5>
                <p>We do not share your personal information with third parties without your consent.</p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>

<script>
$(document).ready(function() {
    $('#memberRegistrationForm').on('submit', function(e) {
        e.preventDefault();
        
        const formData = new FormData(this);
        
        $.ajax({
            url: 'api/register_member.php',
            type: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            success: function(response) {
                if (response.success) {
                    toastr.success('Member registered successfully!');
                    window.location.href = 'members.php';
                } else {
                    toastr.error(response.message);
                }
            },
            error: function() {
                toastr.error('Error registering member');
            }
        });
    });
});
</script>

<?php require_once 'templates/footer.php'; ?>
