<?php
require_once 'config/database.php';
requireAdmin();

require_once 'templates/header.php';
require_once 'templates/navbar.php';
require_once 'templates/sidebar.php';
?>

<!-- Content Wrapper -->
<div class="content-wrapper">
    <!-- Content Header -->
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">Settings Management</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="index.php">Home</a></li>
                        <li class="breadcrumb-item active">Settings</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>

    <!-- Main content -->
    <section class="content">
        <div class="container-fluid">
            <!-- Settings Cards -->
            <div class="row">
                <!-- General Settings -->
                <div class="col-md-6">
                    <div class="card card-primary">
                        <div class="card-header">
                            <h3 class="card-title">General Settings</h3>
                        </div>
                        <form id="generalSettingsForm">
                            <div class="card-body">
                                <div class="form-group">
                                    <label>Organization Name</label>
                                    <input type="text" class="form-control" name="org_name" value="KSO Chandigarh">
                                </div>
                                <div class="form-group">
                                    <label>Contact Email</label>
                                    <input type="email" class="form-control" name="contact_email" value="contact@ksochandigarh.org">
                                </div>
                                <div class="form-group">
                                    <label>Contact Phone</label>
                                    <input type="tel" class="form-control" name="contact_phone" value="+91-9876543210">
                                </div>
                                <div class="form-group">
                                    <label>Address</label>
                                    <textarea class="form-control" name="address" rows="3">Chandigarh, India</textarea>
                                </div>
                            </div>
                            <div class="card-footer">
                                <button type="submit" class="btn btn-primary">Save Changes</button>
                            </div>
                        </form>
                    </div>
                </div>

                <!-- Membership Settings -->
                <div class="col-md-6">
                    <div class="card card-success">
                        <div class="card-header">
                            <h3 class="card-title">Membership Settings</h3>
                        </div>
                        <form id="membershipSettingsForm">
                            <div class="card-body">
                                <div class="form-group">
                                    <label>Individual Membership Fee (₹)</label>
                                    <input type="number" class="form-control" name="individual_fee" value="500">
                                </div>
                                <div class="form-group">
                                    <label>Family Membership Fee (₹)</label>
                                    <input type="number" class="form-control" name="family_fee" value="1000">
                                </div>
                                <div class="form-group">
                                    <label>Late Fee (₹)</label>
                                    <input type="number" class="form-control" name="late_fee" value="100">
                                </div>
                                <div class="form-group">
                                    <label>Membership Validity (Years)</label>
                                    <input type="number" class="form-control" name="validity_years" value="1">
                                </div>
                            </div>
                            <div class="card-footer">
                                <button type="submit" class="btn btn-success">Save Changes</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

            <!-- System Settings -->
            <div class="row">
                <div class="col-md-6">
                    <div class="card card-warning">
                        <div class="card-header">
                            <h3 class="card-title">System Settings</h3>
                        </div>
                        <form id="systemSettingsForm">
                            <div class="card-body">
                                <div class="form-group">
                                    <div class="custom-control custom-switch">
                                        <input type="checkbox" class="custom-control-input" id="maintenanceMode" name="maintenance_mode">
                                        <label class="custom-control-label" for="maintenanceMode">Maintenance Mode</label>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <div class="custom-control custom-switch">
                                        <input type="checkbox" class="custom-control-input" id="emailNotifications" name="email_notifications" checked>
                                        <label class="custom-control-label" for="emailNotifications">Email Notifications</label>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <div class="custom-control custom-switch">
                                        <input type="checkbox" class="custom-control-input" id="autoBackup" name="auto_backup" checked>
                                        <label class="custom-control-label" for="autoBackup">Auto Backup</label>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label>Session Timeout (minutes)</label>
                                    <input type="number" class="form-control" name="session_timeout" value="30">
                                </div>
                            </div>
                            <div class="card-footer">
                                <button type="submit" class="btn btn-warning">Save Changes</button>
                            </div>
                        </form>
                    </div>
                </div>

                <!-- Security Settings -->
                <div class="col-md-6">
                    <div class="card card-danger">
                        <div class="card-header">
                            <h3 class="card-title">Security Settings</h3>
                        </div>
                        <form id="securitySettingsForm">
                            <div class="card-body">
                                <div class="form-group">
                                    <label>Maximum Login Attempts</label>
                                    <input type="number" class="form-control" name="max_login_attempts" value="5">
                                </div>
                                <div class="form-group">
                                    <label>Account Lockout Duration (minutes)</label>
                                    <input type="number" class="form-control" name="lockout_duration" value="15">
                                </div>
                                <div class="form-group">
                                    <label>Password Minimum Length</label>
                                    <input type="number" class="form-control" name="password_min_length" value="8">
                                </div>
                                <div class="form-group">
                                    <div class="custom-control custom-switch">
                                        <input type="checkbox" class="custom-control-input" id="twoFactorAuth" name="two_factor_auth">
                                        <label class="custom-control-label" for="twoFactorAuth">Two-Factor Authentication</label>
                                    </div>
                                </div>
                            </div>
                            <div class="card-footer">
                                <button type="submit" class="btn btn-danger">Save Changes</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

            <!-- All Settings Table -->
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">All Settings</h3>
                            <div class="card-tools">
                                <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#addSettingModal">
                                    <i class="fas fa-plus"></i> Add Setting
                                </button>
                            </div>
                        </div>
                        <div class="card-body">
                            <table id="settingsTable" class="table table-bordered table-striped">
                                <thead>
                                    <tr>
                                        <th>Setting Key</th>
                                        <th>Setting Value</th>
                                        <th>Type</th>
                                        <th>Public</th>
                                        <th>Description</th>
                                        <th>Updated</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <!-- Data will be populated via AJAX -->
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<!-- Add Setting Modal -->
<div class="modal fade" id="addSettingModal" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">Add New Setting</h4>
                <button type="button" class="close" data-dismiss="modal">&times;</button>
            </div>
            <form id="addSettingForm">
                <div class="modal-body">
                    <div class="form-group">
                        <label>Setting Key *</label>
                        <input type="text" class="form-control" name="setting_key" required>
                    </div>
                    <div class="form-group">
                        <label>Setting Value *</label>
                        <textarea class="form-control" name="setting_value" rows="3" required></textarea>
                    </div>
                    <div class="form-group">
                        <label>Setting Type *</label>
                        <select class="form-control" name="setting_type" required>
                            <option value="string">String</option>
                            <option value="integer">Integer</option>
                            <option value="boolean">Boolean</option>
                            <option value="json">JSON</option>
                            <option value="file">File</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label>Description</label>
                        <textarea class="form-control" name="description" rows="2"></textarea>
                    </div>
                    <div class="form-group">
                        <div class="custom-control custom-switch">
                            <input type="checkbox" class="custom-control-input" id="isPublic" name="is_public">
                            <label class="custom-control-label" for="isPublic">Public Setting</label>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary">Add Setting</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
$(document).ready(function() {
    // Initialize DataTable
    const table = $('#settingsTable').DataTable({
        "processing": true,
        "serverSide": false,
        "ajax": {
            "url": "api/fetch_settings.php",
            "dataSrc": function(json) {
                return json.success ? json.data : [];
            }
        },
        "columns": [
            { "data": "setting_key" },
            { "data": "setting_value", "render": function(data) {
                return data.length > 50 ? data.substring(0, 50) + '...' : data;
            }},
            { "data": "setting_type" },
            { "data": "is_public", "render": function(data) {
                return data == 1 ? '<span class="badge badge-success">Yes</span>' : '<span class="badge badge-secondary">No</span>';
            }},
            { "data": "description" },
            { "data": "updated_at", "render": function(data) {
                return new Date(data).toLocaleDateString();
            }},
            { "data": null, "render": function(data) {
                return `
                    <button class="btn btn-sm btn-warning" onclick="editSetting(${data.id})">Edit</button>
                    <button class="btn btn-sm btn-danger" onclick="deleteSetting(${data.id})">Delete</button>
                `;
            }}
        ]
    });

    // Form submissions
    $('#generalSettingsForm, #membershipSettingsForm, #systemSettingsForm, #securitySettingsForm').on('submit', function(e) {
        e.preventDefault();
        const formData = new FormData(this);
        
        $.ajax({
            url: 'api/update_settings.php',
            type: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            success: function(response) {
                if (response.success) {
                    toastr.success('Settings updated successfully');
                } else {
                    toastr.error(response.message);
                }
            },
            error: function() {
                toastr.error('Error updating settings');
            }
        });
    });

    $('#addSettingForm').on('submit', function(e) {
        e.preventDefault();
        const formData = new FormData(this);
        
        $.ajax({
            url: 'api/add_setting.php',
            type: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            success: function(response) {
                if (response.success) {
                    $('#addSettingModal').modal('hide');
                    table.ajax.reload();
                    toastr.success('Setting added successfully');
                } else {
                    toastr.error(response.message);
                }
            },
            error: function() {
                toastr.error('Error adding setting');
            }
        });
    });
});

function editSetting(id) {
    window.location.href = `edit-setting.php?id=${id}`;
}

function deleteSetting(id) {
    if (confirm('Are you sure you want to delete this setting?')) {
        $.post('api/delete_setting.php', {id: id}, function(response) {
            if (response.success) {
                $('#settingsTable').DataTable().ajax.reload();
                toastr.success('Setting deleted successfully');
            } else {
                toastr.error(response.message);
            }
        });
    }
}
</script>

<?php require_once 'templates/footer.php'; ?>
