<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>KSO Chandigarh Admin Panel</title>

    <!-- Google Font: Source Sans Pro -->
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700&display=fallback">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <!-- Ionicons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/ionicons/5.5.2/collection/components/icon/icon.min.css">
    <!-- AdminLTE App (Local) -->
    <link rel="stylesheet" href="dist/css/adminlte.min.css">
    <!-- OverlayScrollbars -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/overlayscrollbars/1.13.1/css/OverlayScrollbars.min.css">
    <!-- DataTables -->
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/dataTables.bootstrap4.min.css">
    <!-- Toastr -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css">
    <!-- Select2 -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css">
    <!-- Select2 Bootstrap4 theme -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@ttskch/select2-bootstrap4-theme@x.x.x/dist/select2-bootstrap4.min.css">
    <!-- Daterange picker -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css">
    <!-- Tempusdominus Bootstrap 4 -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/tempusdominus-bootstrap-4@5.39.0/build/css/tempusdominus-bootstrap-4.min.css">
    <!-- iCheck -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/icheck-bootstrap@3.0.1/icheck-bootstrap.min.css">
    <!-- SweetAlert2 -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css">
    <!-- Pace -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/pace-js@1.2.4/pace-theme-default.min.css">
    
    <style>
        /* Custom KSO Admin Theme */
        :root {
            --primary: #007bff;
            --primary-dark: #0056b3;
            --secondary: #6c757d;
            --success: #28a745;
            --info: #17a2b8;
            --warning: #ffc107;
            --danger: #dc3545;
            --light: #f8f9fa;
            --dark: #343a40;
            --white: #ffffff;
            --gray-100: #f8f9fa;
            --gray-200: #e9ecef;
            --gray-300: #dee2e6;
            --gray-400: #ced4da;
            --gray-500: #adb5bd;
            --gray-600: #6c757d;
            --gray-700: #495057;
            --gray-800: #343a40;
            --gray-900: #212529;
        }

        /* Main Header Styling */
        .main-header.navbar {
            background: linear-gradient(135deg, var(--primary) 0%, var(--primary-dark) 100%);
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
        }

        /* Sidebar Styling */
        .main-sidebar {
            background: linear-gradient(180deg, var(--dark) 0%, #2c3e50 100%);
            box-shadow: 2px 0 8px rgba(0, 0, 0, 0.1);
        }

        .sidebar-dark-primary .nav-sidebar > .nav-item > .nav-link {
            color: rgba(255, 255, 255, 0.9);
            border-radius: 0.375rem;
            margin: 0.125rem 0.5rem;
            padding: 0.75rem 1rem;
            transition: all 0.3s ease;
        }

        .sidebar-dark-primary .nav-sidebar > .nav-item > .nav-link:hover {
            background-color: rgba(255, 255, 255, 0.1);
            color: var(--white);
            transform: translateX(4px);
        }

        .sidebar-dark-primary .nav-sidebar > .nav-item > .nav-link.active {
            background: linear-gradient(135deg, var(--primary) 0%, var(--primary-dark) 100%);
            color: var(--white);
            box-shadow: 0 2px 4px rgba(0, 123, 255, 0.3);
        }

        .sidebar-dark-primary .nav-sidebar > .nav-item > .nav-link.active:hover {
            transform: none;
        }

        /* Content Area */
        .content-wrapper {
            background: linear-gradient(135deg, var(--gray-100) 0%, var(--white) 100%);
            min-height: calc(100vh - 56px);
        }

        /* Cards */
        .card {
            border: none;
            border-radius: 0.75rem;
            box-shadow: 0 0.125rem 0.25rem rgba(0, 0, 0, 0.075);
            transition: all 0.3s ease;
        }

        .card:hover {
            box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.15);
            transform: translateY(-2px);
        }

        .card-header {
            background: linear-gradient(135deg, var(--white) 0%, var(--gray-100) 100%);
            border-bottom: 1px solid var(--gray-200);
            border-radius: 0.75rem 0.75rem 0 0 !important;
            padding: 1rem 1.25rem;
        }

        .card-title {
            color: var(--gray-800);
            font-weight: 600;
            margin-bottom: 0;
        }

        /* Buttons */
        .btn {
            border-radius: 0.375rem;
            font-weight: 500;
            transition: all 0.3s ease;
            position: relative;
            overflow: hidden;
        }

        .btn:before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.2), transparent);
            transition: left 0.5s;
        }

        .btn:hover:before {
            left: 100%;
        }

        .btn-primary {
            background: linear-gradient(135deg, var(--primary) 0%, var(--primary-dark) 100%);
            border: none;
            box-shadow: 0 2px 4px rgba(0, 123, 255, 0.3);
        }

        .btn-primary:hover {
            background: linear-gradient(135deg, var(--primary-dark) 0%, #003d82 100%);
            transform: translateY(-1px);
            box-shadow: 0 4px 8px rgba(0, 123, 255, 0.4);
        }

        .btn-success {
            background: linear-gradient(135deg, var(--success) 0%, #1e7e34 100%);
            border: none;
        }

        .btn-warning {
            background: linear-gradient(135deg, var(--warning) 0%, #e0a800 100%);
            border: none;
        }

        .btn-danger {
            background: linear-gradient(135deg, var(--danger) 0%, #c82333 100%);
            border: none;
        }

        .btn-info {
            background: linear-gradient(135deg, var(--info) 0%, #138496 100%);
            border: none;
        }

        /* Small Boxes */
        .small-box {
            border-radius: 0.75rem;
            box-shadow: 0 0.25rem 0.5rem rgba(0, 0, 0, 0.1);
            position: relative;
            overflow: hidden;
        }

        .small-box:before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: linear-gradient(135deg, transparent 0%, rgba(255, 255, 255, 0.1) 100%);
            pointer-events: none;
        }

        .small-box .icon {
            color: rgba(255, 255, 255, 0.8);
            font-size: 4rem;
            transition: all 0.3s ease;
        }

        .small-box:hover .icon {
            transform: scale(1.1);
        }

        /* Info Boxes */
        .info-box {
            border-radius: 0.75rem;
            box-shadow: 0 0.125rem 0.25rem rgba(0, 0, 0, 0.075);
            border: none;
        }

        .info-box-icon {
            border-radius: 0.75rem 0 0 0.75rem;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        /* Tables */
        .table {
            background-color: var(--white);
            border-radius: 0.75rem;
            overflow: hidden;
        }

        .table th {
            background: linear-gradient(135deg, var(--gray-100) 0%, var(--gray-200) 100%);
            border-top: none;
            font-weight: 600;
            color: var(--gray-800);
            font-size: 0.875rem;
            text-transform: uppercase;
            letter-spacing: 0.05em;
            padding: 1rem 0.75rem;
        }

        .table td {
            vertical-align: middle;
            border-top: 1px solid var(--gray-200);
            padding: 0.75rem;
        }

        .table-hover tbody tr:hover {
            background-color: var(--gray-100);
        }

        /* Forms */
        .form-control {
            border-radius: 0.375rem;
            border: 1px solid var(--gray-300);
            transition: all 0.3s ease;
        }

        .form-control:focus {
            border-color: var(--primary);
            box-shadow: 0 0 0 0.2rem rgba(0, 123, 255, 0.25);
        }

        .form-group label {
            font-weight: 500;
            color: var(--gray-700);
            margin-bottom: 0.5rem;
        }

        /* Modals */
        .modal-content {
            border-radius: 0.75rem;
            border: none;
            box-shadow: 0 1rem 3rem rgba(0, 0, 0, 0.3);
        }

        .modal-header {
            background: linear-gradient(135deg, var(--white) 0%, var(--gray-100) 100%);
            border-bottom: 1px solid var(--gray-200);
            border-radius: 0.75rem 0.75rem 0 0;
        }

        .modal-footer {
            background: linear-gradient(135deg, var(--gray-100) 0%, var(--white) 100%);
            border-top: 1px solid var(--gray-200);
            border-radius: 0 0 0.75rem 0.75rem;
        }

        /* Badges */
        .badge {
            border-radius: 0.375rem;
            font-weight: 500;
            padding: 0.375rem 0.75rem;
        }

        .badge-primary { background: linear-gradient(135deg, var(--primary) 0%, var(--primary-dark) 100%); }
        .badge-success { background: linear-gradient(135deg, var(--success) 0%, #1e7e34 100%); }
        .badge-warning { background: linear-gradient(135deg, var(--warning) 0%, #e0a800 100%); }
        .badge-danger { background: linear-gradient(135deg, var(--danger) 0%, #c82333 100%); }
        .badge-info { background: linear-gradient(135deg, var(--info) 0%, #138496 100%); }

        /* Alerts */
        .alert {
            border: none;
            border-radius: 0.75rem;
            border-left: 4px solid;
        }

        .alert-primary { 
            background: linear-gradient(135deg, #cce7ff 0%, #e6f3ff 100%); 
            border-left-color: var(--primary); 
            color: var(--primary-dark);
        }

        .alert-success { 
            background: linear-gradient(135deg, #d4edda 0%, #e8f5e8 100%); 
            border-left-color: var(--success); 
            color: #155724;
        }

        .alert-warning { 
            background: linear-gradient(135deg, #fff3cd 0%, #fffae6 100%); 
            border-left-color: var(--warning); 
            color: #856404;
        }

        .alert-danger { 
            background: linear-gradient(135deg, #f8d7da 0%, #fce8e6 100%); 
            border-left-color: var(--danger); 
            color: #721c24;
        }

        /* Navigation */
        .nav-pills .nav-link {
            border-radius: 0.375rem;
            transition: all 0.3s ease;
        }

        .nav-pills .nav-link.active {
            background: linear-gradient(135deg, var(--primary) 0%, var(--primary-dark) 100%);
        }

        .nav-tabs .nav-link {
            border-radius: 0.375rem 0.375rem 0 0;
            transition: all 0.3s ease;
        }

        .nav-tabs .nav-link.active {
            color: var(--primary);
            background-color: var(--white);
            border-color: var(--gray-300) var(--gray-300) var(--white);
        }

        /* Pagination */
        .page-link {
            color: var(--primary);
            border-radius: 0.375rem;
            margin: 0 0.125rem;
            transition: all 0.3s ease;
        }

        .page-link:hover {
            color: var(--primary-dark);
            background-color: var(--gray-200);
        }

        .page-item.active .page-link {
            background: linear-gradient(135deg, var(--primary) 0%, var(--primary-dark) 100%);
            border-color: var(--primary);
        }

        /* Progress Bars */
        .progress {
            border-radius: 0.375rem;
            overflow: hidden;
        }

        .progress-bar {
            background: linear-gradient(135deg, var(--primary) 0%, var(--primary-dark) 100%);
            transition: width 0.6s ease;
        }

        /* Dropdown */
        .dropdown-menu {
            border: none;
            border-radius: 0.75rem;
            box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.15);
            padding: 0.5rem 0;
        }

        .dropdown-item {
            padding: 0.75rem 1rem;
            transition: all 0.3s ease;
        }

        .dropdown-item:hover {
            background-color: var(--gray-100);
            color: var(--primary);
        }

        /* Content Header */
        .content-header {
            background: linear-gradient(135deg, var(--white) 0%, var(--gray-100) 100%);
            border-bottom: 1px solid var(--gray-200);
            border-radius: 0.75rem;
            margin-bottom: 1rem;
            padding: 1.5rem 1rem;
        }

        .content-header h1 {
            color: var(--gray-800);
            font-weight: 700;
            margin-bottom: 0;
        }

        .breadcrumb {
            background-color: transparent;
            margin-bottom: 0;
            padding: 0;
        }

        .breadcrumb-item a {
            color: var(--primary);
            text-decoration: none;
        }

        .breadcrumb-item.active {
            color: var(--gray-600);
        }

        /* Brand Link */
        .brand-link {
            background: linear-gradient(135deg, var(--dark) 0%, #2c3e50 100%);
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
            padding: 1rem;
        }

        .brand-text {
            color: var(--white) !important;
            font-weight: 600;
            font-size: 1.25rem;
        }

        /* User Panel */
        .user-panel {
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
            padding: 1rem;
        }

        .user-panel .info a {
            color: var(--white);
            font-weight: 500;
        }

        /* Loading Animation */
        .loading {
            position: relative;
            overflow: hidden;
        }

        .loading::after {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.4), transparent);
            animation: shimmer 1.5s infinite;
        }

        @keyframes shimmer {
            0% { left: -100%; }
            100% { left: 100%; }
        }

        /* Responsive Design */
        @media (max-width: 768px) {
            .content-header {
                padding: 1rem;
            }
            
            .content-header h1 {
                font-size: 1.5rem;
            }
            
            .card {
                margin-bottom: 1rem;
            }
            
            .btn {
                padding: 0.375rem 0.75rem;
                font-size: 0.875rem;
            }
            
            .table-responsive {
                font-size: 0.875rem;
            }
        }

        /* Print Styles */
        @media print {
            .main-sidebar,
            .main-header,
            .content-header,
            .btn,
            .card-tools {
                display: none !important;
            }
            
            .content-wrapper {
                margin-left: 0 !important;
                background: white !important;
            }
            
            .card {
                box-shadow: none !important;
                border: 1px solid #000 !important;
            }
        }
    </style>
    
    <!-- KSO Enhanced JavaScript Components -->
    <script src="dist/js/preloader.js"></script>
    <script src="dist/js/theme-manager.js"></script>
    <script src="dist/js/toast.js"></script>
    <script src="dist/js/timeline.js"></script>
    <script src="dist/js/dashboard-widgets.js"></script>
    <script src="dist/js/print-system.js"></script>
    <script src="dist/js/breadcrumbs.js"></script>
</head>
<body class="hold-transition sidebar-mini layout-fixed">
<div class="wrapper">
