# KSO Favicon Creation Guide

This guide explains how to create a proper favicon for the KSO Chandigarh Admin Panel.

## What is a Favicon?

A favicon is a small icon that appears in browser tabs, bookmarks, and other places to represent your website. It helps with branding and recognition.

## How to Create a KSO Favicon

1. **Option 1: Use an Online Favicon Generator**
   - Visit a site like [favicon.io](https://favicon.io/) or [realfavicongenerator.net](https://realfavicongenerator.net/)
   - Upload the KSO logo or create a text-based icon with "KSO"
   - Download the generated favicon.ico file
   - Replace the placeholder favicon.ico file in the root directory and adminlte directory

2. **Option 2: Create with Image Editing Software**
   - Use Photoshop, GIMP, or another image editor
   - Create a 16x16 or 32x32 pixel image with the KSO logo or initials
   - Save as favicon.ico format
   - Replace the placeholder favicon.ico file

## Implementation Details

The favicon has already been referenced in the header template with these lines:

```html
<!-- Favicon -->
<link rel="shortcut icon" href="../favicon.ico" type="image/x-icon">
<link rel="icon" href="../favicon.ico" type="image/x-icon">
```

Simply replace the placeholder favicon.ico files with your actual icon, and it will automatically appear in browser tabs.

## Locations to Update

Place your favicon.ico file in:
1. `c:\Users\samue\OneDrive\Documents\public_html\favicon.ico` (root directory)
2. `c:\Users\samue\OneDrive\Documents\public_html\adminlte\favicon.ico` (adminlte directory)
