# KSO Chandigarh - Complete API Documentation
## All Available APIs and Endpoints

### 🌐 API Base URL
```
http://localhost/KSOCHD/api/
```

---

## 🔐 Authentication APIs

### Login & Session Management
- **File**: `api/auth/login.php`
- **Methods**: POST
- **Description**: Admin authentication

```javascript
// Login
POST /api/auth/login
{
    "username": "admin",
    "password": "password"
}

// Response
{
    "success": true,
    "message": "Login successful",
    "admin": {
        "id": 1,
        "username": "admin",
        "role": "super_admin"
    }
}
```

### Session Management
- **File**: `api/auth/session.php`
- **Methods**: GET
- **Description**: Check current session

```javascript
GET /api/auth/session
// Response
{
    "success": true,
    "authenticated": true,
    "admin": {...}
}
```

### Logout
- **File**: `api/auth/logout.php`
- **Methods**: POST

---

## 📊 Dashboard APIs

### Dashboard Data
- **File**: `api/dashboard.php`
- **Methods**: GET
- **Description**: Main dashboard statistics

```javascript
GET /api/dashboard
// Response
{
    "success": true,
    "data": {
        "total_members": 150,
        "pending_approvals": 5,
        "total_events": 12,
        "total_revenue": "250000.00",
        "recent_registrations": [...],
        "upcoming_events": [...],
        "recent_transactions": [...]
    }
}
```

---

## 👥 Member Management APIs

### Member Operations
- **File**: `api/members/index.php`
- **Methods**: GET, POST, PUT, DELETE

```javascript
// Get all members
GET /api/members/index.php?status=active&limit=50&offset=0

// Get specific member
GET /api/members/member.php?id=123

// Create new member
POST /api/members/index.php
{
    "first_name": "John",
    "last_name": "Doe",
    "email": "john@example.com",
    "phone": "9876543210",
    "membership_type": "annual",
    "address": "123 Street, City"
}

// Update member
PUT /api/members/index.php
{
    "id": 123,
    "first_name": "John Updated",
    ...
}

// Delete member
DELETE /api/members/index.php?id=123
```

### Member Approval System
- **File**: `api/members/approve.php`
- **Methods**: POST

```javascript
POST /api/members/approve.php
{
    "member_id": 123,
    "status": "approved",
    "notes": "All documents verified"
}
```

- **File**: `api/members/reject.php`
- **Methods**: POST

```javascript
POST /api/members/reject.php
{
    "member_id": 123,
    "reason": "Incomplete documentation"
}
```

### Member Statistics
- **File**: `api/members/stats.php`
- **Methods**: GET

```javascript
GET /api/members/stats.php
// Response
{
    "success": true,
    "data": {
        "total_members": 150,
        "active_members": 145,
        "pending_approval": 5,
        "membership_types": {
            "annual": 80,
            "lifetime": 65,
            "family": 5
        }
    }
}
```

---

## 💰 Finance & Receipt APIs

### Finance Transactions
- **File**: `api/finance/index.php`
- **Methods**: GET, POST, PUT, DELETE

```javascript
// Get transactions
GET /api/finance/index.php?type=income&limit=50

// Create transaction
POST /api/finance/index.php
{
    "member_id": 123,
    "amount": 5000.00,
    "transaction_type": "membership_fee",
    "payment_method": "cash",
    "description": "Annual membership fee"
}

// Update transaction
PUT /api/finance/index.php
{
    "id": 456,
    "amount": 5500.00,
    "status": "completed"
}
```

### Finance Statistics
- **File**: `api/finance/stats.php`
- **Methods**: GET

```javascript
GET /api/finance/stats.php
// Response
{
    "success": true,
    "data": {
        "total_income": "500000.00",
        "total_expenses": "150000.00",
        "net_balance": "350000.00",
        "this_month_income": "45000.00",
        "monthly_breakdown": [...]
    }
}
```

---

## 🧾 Receipt & Invoice APIs

### Receipt Management
- **File**: `api/receipts/index.php`
- **Methods**: GET, POST, DELETE

```javascript
// Get all receipts
GET /api/receipts/receipts?search=KSO-MF&transaction_type=membership_fee&limit=20

// Response
{
    "success": true,
    "data": [
        {
            "id": 1,
            "receipt_number": "KSO-MF-202507001",
            "member_name": "John Doe",
            "amount": "5000.00",
            "transaction_type": "membership_fee",
            "created_at": "2025-07-10 10:30:00",
            "file_path": "storage/receipts/2025/07/KSO-MF-202507001.html"
        }
    ]
}

// Generate new receipt
POST /api/receipts/generate
{
    "transaction_id": 123,
    "template": "standard"
}

// Response
{
    "success": true,
    "data": {
        "receipt_id": 456,
        "receipt_number": "KSO-MF-202507002",
        "file_path": "storage/receipts/2025/07/KSO-MF-202507002.html"
    }
}

// View receipt
GET /api/receipts/view/456

// Delete receipt
DELETE /api/receipts/456
```

### Receipt Statistics
```javascript
GET /api/receipts/stats
// Response
{
    "success": true,
    "data": {
        "total_receipts": 150,
        "today_receipts": 5,
        "this_month_receipts": 45,
        "total_amount": "750000.00"
    }
}
```

### Invoice Management
```javascript
// Get invoices
GET /api/receipts/invoices?status=pending&due_date=2025-07-15

// Create invoice
POST /api/receipts/invoices
{
    "member_id": 123,
    "total_amount": 5000.00,
    "due_date": "2025-08-10",
    "items": [
        {
            "description": "Annual Membership Fee",
            "amount": 5000.00,
            "quantity": 1
        }
    ]
}

// Update invoice
PUT /api/receipts/invoices/456
{
    "status": "paid",
    "paid_amount": 5000.00,
    "paid_date": "2025-07-10"
}

// Mark invoice as paid
POST /api/receipts/invoices/456/pay
{
    "payment_transaction_id": 789,
    "paid_amount": 5000.00
}
```

---

## 🎉 Event Management APIs

### Event Operations
- **File**: `api/events/index.php`
- **Methods**: GET, POST, PUT, DELETE

```javascript
// Get events
GET /api/events/index.php?status=upcoming&limit=20

// Create event
POST /api/events/index.php
{
    "title": "Annual Cultural Program",
    "description": "Traditional dance and music",
    "event_date": "2025-08-15",
    "location": "Community Hall",
    "registration_fee": 500.00,
    "max_participants": 100
}

// Update event
PUT /api/events/index.php
{
    "id": 123,
    "title": "Updated Event Title",
    "status": "active"
}
```

### Event Registrations
- **File**: `api/events/registrations.php`
- **Methods**: GET, POST

```javascript
// Get event registrations
GET /api/events/registrations.php?event_id=123

// Register member for event
POST /api/events/registrations.php
{
    "event_id": 123,
    "member_id": 456,
    "registration_fee": 500.00,
    "payment_method": "online"
}
```

### Event Statistics
- **File**: `api/events/stats.php`
- **Methods**: GET

```javascript
GET /api/events/stats.php
// Response
{
    "success": true,
    "data": {
        "total_events": 25,
        "upcoming_events": 5,
        "total_registrations": 450,
        "total_revenue": "125000.00"
    }
}
```

---

## 💸 Expense Management APIs

### Expense Operations
- **File**: `api/expenses/index.php`
- **Methods**: GET, POST, PUT, DELETE

```javascript
// Get expenses
GET /api/expenses/index.php?category=event&date_from=2025-07-01

// Create expense
POST /api/expenses/index.php
{
    "category": "event",
    "amount": 15000.00,
    "description": "Event decoration and catering",
    "expense_date": "2025-07-10",
    "approved_by": 1
}

// Update expense
PUT /api/expenses/index.php
{
    "id": 123,
    "amount": 16000.00,
    "status": "approved"
}
```

---

## 💳 Membership Fee APIs

### Fee Management
- **File**: `api/membership-fees/index.php`
- **Methods**: GET, POST, PUT

```javascript
// Get membership fees
GET /api/membership-fees/index.php?member_id=123&year=2025

// Record fee payment
POST /api/membership-fees/index.php
{
    "member_id": 123,
    "amount": 5000.00,
    "fee_year": 2025,
    "payment_method": "bank_transfer",
    "transaction_reference": "TXN123456"
}

// Update fee record
PUT /api/membership-fees/index.php
{
    "id": 456,
    "status": "paid",
    "receipt_generated": true
}
```

---

## 🔔 Notification APIs

### Notification Management
- **File**: `api/notifications/index.php`
- **Methods**: GET, POST, PUT, DELETE

```javascript
// Get notifications
GET /api/notifications/index.php?type=system&status=unread

// Create notification
POST /api/notifications/index.php
{
    "title": "New Member Registration",
    "message": "John Doe has registered for membership",
    "type": "member_registration",
    "priority": "normal"
}

// Mark as read
PUT /api/notifications/index.php
{
    "id": 123,
    "status": "read"
}
```

---

## 📧 Email APIs

### Email Management
- **File**: `api/emails/index.php`
- **Methods**: GET, POST

```javascript
// Get email logs
GET /api/emails/index.php?type=welcome&status=sent

// Send email
POST /api/emails/send
{
    "to": "member@example.com",
    "template": "welcome",
    "data": {
        "member_name": "John Doe",
        "kso_id": "KSO001"
    }
}

// Get email templates
GET /api/emails/templates

// Get email settings
GET /api/emails/settings
```

---

## 🆔 ID Card APIs

### ID Card Management
- **File**: `api/id-cards/index.php`
- **Methods**: GET, POST

```javascript
// Get ID card requests
GET /api/id-cards/index.php?status=pending

// Generate ID card
POST /api/id-cards/generate
{
    "member_id": 123,
    "card_type": "standard",
    "expedited": false
}
```

---

## 📄 Document APIs

### Document Management
- **File**: `api/documents/index.php`
- **Methods**: GET, POST, DELETE

```javascript
// Get documents
GET /api/documents/index.php?member_id=123&type=verification

// Upload document
POST /api/documents/index.php
{
    "member_id": 123,
    "document_type": "identity_proof",
    "file_name": "aadhar_card.pdf",
    "file_data": "base64_encoded_data"
}
```

---

## 📊 Reports APIs

### Report Generation
- **File**: `api/reports/index.php`
- **Methods**: GET, POST

```javascript
// Get available reports
GET /api/reports/index.php

// Generate report
POST /api/reports/generate
{
    "report_type": "financial_summary",
    "date_from": "2025-01-01",
    "date_to": "2025-07-10",
    "format": "pdf"
}

// Download report
GET /api/reports/download/123
```

---

## ⚙️ Settings APIs

### System Settings
- **File**: `api/settings/index.php`
- **Methods**: GET, POST, PUT

```javascript
// Get all settings
GET /api/settings/index.php

// Get specific setting
GET /api/settings/index.php?key=org_name

// Update settings
PUT /api/settings/index.php
{
    "settings": {
        "org_name": "KSO Chandigarh",
        "email_smtp_host": "smtp.gmail.com",
        "membership_fee_annual": "5000"
    }
}
```

---

## 🔧 Common API Patterns

### Standard Request Headers
```javascript
{
    "Content-Type": "application/json",
    "Authorization": "Bearer token_here"  // If using token auth
}
```

### Standard Response Format
```javascript
{
    "success": true|false,
    "message": "Status message",
    "data": {...}|[...],
    "error": "Error details if any",
    "pagination": {
        "total": 100,
        "page": 1,
        "limit": 20,
        "offset": 0
    }
}
```

### Common Query Parameters
- `limit` - Number of results to return
- `offset` - Pagination offset
- `search` - Search term
- `status` - Filter by status
- `date_from` - Start date filter
- `date_to` - End date filter
- `sort_by` - Sort field
- `sort_order` - asc|desc

### Error Codes
- `200` - Success
- `400` - Bad Request
- `401` - Unauthorized
- `403` - Forbidden
- `404` - Not Found
- `500` - Internal Server Error

---

## 🚀 API Testing

### Using cURL
```bash
# Test login
curl -X POST http://localhost/KSOCHD/api/auth/login \
  -H "Content-Type: application/json" \
  -d '{"username":"admin","password":"password"}'

# Test receipt generation
curl -X POST http://localhost/KSOCHD/api/receipts/generate \
  -H "Content-Type: application/json" \
  -d '{"transaction_id":1}'

# Test member listing
curl -X GET "http://localhost/KSOCHD/api/members/index.php?limit=10"
```

### Using JavaScript Fetch
```javascript
// Login
const login = await fetch('/api/auth/login', {
    method: 'POST',
    headers: {'Content-Type': 'application/json'},
    body: JSON.stringify({username: 'admin', password: 'password'})
});

// Get members
const members = await fetch('/api/members/index.php?limit=20');
const memberData = await members.json();

// Generate receipt
const receipt = await fetch('/api/receipts/generate', {
    method: 'POST',
    headers: {'Content-Type': 'application/json'},
    body: JSON.stringify({transaction_id: 123})
});
```

---

*Last Updated: July 10, 2025*
*Total APIs: 15+ endpoints with 50+ operations*
