# KSO Database Setup Guide

## Current Status
✅ XAMPP is running
✅ phpMyAdmin is accessible at: http://localhost/phpmyadmin/

## Database Setup Steps

### Step 1: Create the KSO Database
1. In phpMyAdmin, click on "Databases" in the top menu
2. Enter database name: `ktxmmosu_kso_chandigarh`
3. Select collation: `utf8mb4_general_ci` (recommended for multi-language support)
4. Click "Create"

### Step 2: Import the SQL Schema
1. Click on the newly created database `ktxmmosu_kso_chandigarh`
2. Click on the "Import" tab
3. Click "Choose File" and select: `ktxmmosu_kso_chandigarh.sql`
4. Keep default settings:
   - Format: SQL
   - Character set: utf8
   - Partial import: unchecked
5. Click "Go" to start import

### Step 3: Verify Import Success
After import, you should see these tables:
- `admins` - Admin login credentials
- `members` - Member information
- `events` - Event management
- `event_registrations` - Event registrations
- `expenses` - Expense tracking
- `finance` - Financial records
- `notifications` - System notifications
- `documents` - Document management
- `membership_fees` - Fee tracking
- `id_cards` - ID card management

### Step 4: Verify Database Connection
1. Open: `api/config.php`
2. Confirm database settings match:
   ```php
   $servername = "localhost";
   $username = "root";
   $password = "";
   $dbname = "ktxmmosu_kso_chandigarh";
   ```

### Step 5: Test Database Connection
Create a simple test to verify connection works.

## Default Admin Credentials
After import, you can login with:
- **Username:** admin
- **Password:** admin123

⚠️ **IMPORTANT:** Change these credentials immediately after first login!

## Database User Setup (Optional - For Production)
For production deployment, create a dedicated database user:

1. In phpMyAdmin, go to "User accounts"
2. Click "Add user account"
3. Enter username: `kso_user`
4. Set a secure password
5. Grant privileges:
   - SELECT, INSERT, UPDATE, DELETE
   - CREATE, DROP, ALTER
   - INDEX, REFERENCES
6. Limit to database: `ktxmmosu_kso_chandigarh`

## Troubleshooting

### If Import Fails:
1. Check file size limits in phpMyAdmin
2. Try importing in smaller chunks
3. Check for SQL syntax errors
4. Verify foreign key constraints are properly ordered

### If Connection Fails:
1. Verify MySQL service is running in XAMPP
2. Check database name spelling
3. Verify credentials in `api/config.php`
4. Test with simple PHP connection script

## Next Steps After Database Setup
1. Test admin login
2. Test member registration
3. Verify all API endpoints work
4. Check data integrity
5. Set up regular backups

## Security Checklist
- [ ] Change default admin password
- [ ] Create dedicated database user
- [ ] Remove test/demo data
- [ ] Set up regular backups
- [ ] Configure proper file permissions
- [ ] Enable SSL for production
