# Email Setup Quick Guide - KSO Chandigarh

## 🚀 Quick Email Setup (5 Minutes)

### **Step 1: Database Setup**
Execute these SQL commands in your MySQL database:

```sql
-- Create email logs table
CREATE TABLE IF NOT EXISTS `email_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `to_email` varchar(255) NOT NULL,
  `subject` varchar(500) NOT NULL,
  `template_used` varchar(100) DEFAULT NULL,
  `status` enum('sent','failed','pending') DEFAULT 'pending',
  `error_message` text DEFAULT NULL,
  `sent_at` datetime DEFAULT current_timestamp(),
  `retry_count` int(11) DEFAULT 0,
  `user_id` int(11) DEFAULT NULL,
  `user_type` enum('admin','member') DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_to_email` (`to_email`),
  KEY `idx_status` (`status`),
  KEY `idx_sent_at` (`sent_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Insert email settings
INSERT INTO `settings` (`setting_key`, `setting_value`, `setting_type`, `description`, `is_public`) VALUES
('email_enabled', '0', 'boolean', 'Enable/Disable Email Service', 0),
('smtp_host', 'localhost', 'string', 'SMTP Server Host', 0),
('smtp_port', '587', 'integer', 'SMTP Server Port', 0),
('smtp_username', '', 'string', 'SMTP Username/Email', 0),
('smtp_password', '', 'string', 'SMTP Password', 0),
('smtp_encryption', 'tls', 'string', 'SMTP Encryption Type', 0),
('email_from_address', 'noreply@ksochandigarh.com', 'string', 'Default From Email', 0),
('email_from_name', 'KSO Chandigarh', 'string', 'Default From Name', 0),
('email_auto_welcome', '1', 'boolean', 'Send automatic welcome emails', 0),
('email_auto_approval', '1', 'boolean', 'Send automatic approval emails', 0),
('email_auto_events', '1', 'boolean', 'Send automatic event emails', 0),
('email_auto_fees', '1', 'boolean', 'Send automatic fee reminders', 0)
ON DUPLICATE KEY UPDATE `setting_value` = VALUES(`setting_value`);
```

### **Step 2: Gmail App Password Setup**

1. **Enable 2-Factor Authentication:**
   - Go to [Google Account Security](https://myaccount.google.com/security)
   - Enable 2-Factor Authentication if not already enabled

2. **Generate App Password:**
   - Go to Security → App Passwords
   - Select "Mail" as the app
   - Copy the generated 16-character password

### **Step 3: Configure Email Settings**

1. **Access Admin Panel:**
   - Login to KSO admin dashboard
   - Navigate to **Settings → Email Settings**

2. **SMTP Configuration:**
   ```
   SMTP Host: smtp.gmail.com
   SMTP Port: 587
   Encryption: TLS
   Username: your-email@gmail.com
   Password: [16-character app password from Step 2]
   From Email: noreply@ksochandigarh.com
   From Name: KSO Chandigarh
   ```

3. **Enable Email Service:**
   - Check "Enable Email Service"
   - Enable automation options as needed

4. **Test Configuration:**
   - Enter your email in "Test Email Address"
   - Click "Send Test Email"
   - Check your inbox for test email

### **Step 4: Verify Templates**
The following templates are already created:
- ✅ `api/templates/email/welcome.html`
- ✅ `api/templates/email/approval.html`
- ✅ `api/templates/email/event-reminder.html`
- ✅ `api/templates/email/fee-reminder.html`

### **Step 5: Test Functionality**

1. **Test Member Registration:**
   - Register a new member
   - Check if welcome email is received

2. **Test Member Approval:**
   - Approve a pending member
   - Check if approval email is received

## 📧 **Email Templates Available:**

### **Welcome Email** (`welcome.html`)
- Sent automatically when new members register
- Contains member details and next steps
- Professional design with KSO branding

### **Approval Email** (`approval.html`)
- Sent when admin approves membership
- Includes membership details and portal access
- Encourages engagement with KSO activities

### **Event Reminder** (`event-reminder.html`)
- For notifying members about upcoming events
- Includes event details, date, time, location
- Professional event promotion design

### **Fee Reminder** (`fee-reminder.html`)
- Payment reminder with fee details
- Multiple payment options (UPI, Bank Transfer)
- Clear payment instructions and deadlines

## 🔧 **Troubleshooting:**

### **Common Issues:**

**1. Test Email Fails:**
- Check Gmail app password is correct
- Verify SMTP settings
- Ensure 2FA is enabled on Gmail

**2. Emails Not Sending:**
- Check email service is enabled
- Verify SMTP configuration
- Check email logs in admin panel

**3. Templates Not Loading:**
- Verify templates exist in `api/templates/email/`
- Check file permissions
- Review error logs

### **Settings Location:**
- Email settings: **Admin → Settings → Email Settings**
- Email logs: Check via admin settings or database `email_logs` table
- Email stats: Displayed in email settings section

## 📊 **Email Analytics:**
Monitor email performance through:
- Success/failure rates
- Daily/weekly sending volumes
- Template usage statistics
- Recent email activity logs

## 🔒 **Security Notes:**
- Use app passwords, not regular Gmail passwords
- Keep SMTP credentials secure
- Regularly monitor email logs for unusual activity
- Test email functionality after any configuration changes

---

## ✅ **Verification Checklist:**

- [ ] Database tables created
- [ ] Gmail app password generated
- [ ] SMTP settings configured
- [ ] Email service enabled
- [ ] Test email sent successfully
- [ ] Welcome email works for new registrations
- [ ] Approval email works for member approvals
- [ ] Email statistics display correctly

**🎉 Once all items are checked, your email system is fully operational!**

---
**Setup Time**: ~5 minutes  
**Difficulty**: Easy  
**Support**: Check `email_logs` table for troubleshooting
