# KSO Chandigarh - Family Membership & ID System Guide

## Overview
The KSO Chandigarh Management System now supports auto-incrementing KSOCHD IDs and comprehensive family membership functionality with dependent management.

## New ID System

### Member IDs
- **Format**: `KSOCHD001`, `KSOCHD002`, `KSOCHD003`, etc.
- **Auto-increment**: Automatically generates the next available number
- **Database Logic**: 
  ```sql
  SELECT MAX(CAST(SUBSTRING(kso_id, 7) AS UNSIGNED)) as max_id 
  FROM members WHERE kso_id LIKE 'KSOCHD%'
  ```

### Dependent IDs
- **Format**: Same as member IDs (`KSOCHD001`, `KSOCHD002`, etc.)
- **Separate Counter**: Dependents have their own auto-increment sequence
- **Database Logic**:
  ```sql
  SELECT MAX(CAST(SUBSTRING(kso_id, 7) AS UNSIGNED)) as max_id 
  FROM dependents WHERE kso_id LIKE 'KSOCHD%'
  ```

## Family Membership Features

### 1. Dynamic Form Interface
- **Individual Membership**: Standard registration form
- **Family Membership**: Additional dependent section appears automatically
- **JavaScript Functions**:
  - `toggleDependents()`: Shows/hides dependent section based on membership type
  - `addDependent()`: Dynamically adds dependent form fields
  - `removeDependent()`: Removes dependent form fields

### 2. Dependent Information Required
When "Family" membership is selected, the following dependent details are required:
- **Personal Information**:
  - First Name (Required)
  - Last Name (Required)
  - Date of Birth (Required)
  - Gender (Required)
  - Relationship (Required): Spouse, Child, Sibling, Parent, Other

- **Academic Information** (Optional):
  - College/University
  - Course/Program
  - Year of Study

### 3. Database Structure
The `dependents` table includes:
```sql
CREATE TABLE `dependents` (
  `id` int(11) NOT NULL,
  `member_id` int(11) NOT NULL,
  `kso_id` varchar(20) NOT NULL,  -- Auto-generated KSOCHD ID
  `first_name` varchar(100) NOT NULL,
  `last_name` varchar(100) NOT NULL,
  `relationship` enum('Spouse','Child','Sibling','Parent','Other') NOT NULL,
  `date_of_birth` date DEFAULT NULL,
  `gender` enum('Male','Female','Other') DEFAULT NULL,
  `course` varchar(255) DEFAULT NULL,
  `college` varchar(255) DEFAULT NULL,
  `year_of_study` int(11) DEFAULT NULL,
  `notes` text DEFAULT NULL,
  `created_at` datetime DEFAULT current_timestamp(),
  `updated_at` datetime DEFAULT current_timestamp() ON UPDATE current_timestamp()
)
```

## Registration Process

### Individual Membership
1. User fills out standard registration form
2. Selects "Individual" membership type
3. System generates KSOCHD ID (e.g., `KSOCHD001`)
4. Member is registered with active status

### Family Membership
1. User fills out standard registration form
2. Selects "Family" membership type
3. Dependent section appears automatically
4. User clicks "Add Dependent" to add family members
5. System generates KSOCHD ID for primary member
6. System generates separate KSOCHD IDs for each dependent
7. All records are saved with proper relationships

## User Interface Features

### Dynamic Form Elements
- **Membership Type Dropdown**: Triggers dependent section visibility
- **Add Dependent Button**: Appears only for family membership
- **Dependent Cards**: Each dependent gets a card with form fields
- **Remove Dependent Button**: Allows removal of individual dependents

### Form Validation
- **Required Fields**: All dependent fields are required when family membership is selected
- **Password Validation**: Ensures password and repeat password match
- **Email Validation**: Prevents duplicate email registrations

## Success Messages
- **Individual**: "Member registration successful! Welcome to KSO Chandigarh. Member ID: KSOCHD001"
- **Family**: "Member registration successful! Welcome to KSO Chandigarh. Member ID: KSOCHD001. Added 2 dependents."

## Admin Dashboard Integration
- **Member List**: Shows KSOCHD IDs for all members
- **Membership Type**: Displays Individual/Family badges
- **Recent Members**: Lists latest registrations with IDs
- **Statistics**: Counts total members and active members

## Testing
A test page (`test_registration.php`) is available to verify:
- Current member and dependent counts
- Last 5 registered members with their IDs
- All dependents with their relationships
- Next ID generation for both members and dependents

## Database Queries

### Get Next Member ID
```sql
SELECT MAX(CAST(SUBSTRING(kso_id, 7) AS UNSIGNED)) as max_id 
FROM members WHERE kso_id LIKE 'KSOCHD%'
```

### Get Next Dependent ID
```sql
SELECT MAX(CAST(SUBSTRING(kso_id, 7) AS UNSIGNED)) as max_id 
FROM dependents WHERE kso_id LIKE 'KSOCHD%'
```

### Get Family Members
```sql
SELECT m.kso_id as member_id, m.first_name, m.last_name,
       d.kso_id as dependent_id, d.first_name, d.last_name, d.relationship
FROM members m 
LEFT JOIN dependents d ON m.id = d.member_id 
WHERE m.membership_type = 'Family'
```

## Benefits
1. **Unique Identification**: Each member and dependent has a unique KSOCHD ID
2. **Family Management**: Complete family membership support
3. **Auto-increment**: No manual ID management required
4. **Scalable**: System can handle thousands of members
5. **User-friendly**: Dynamic form interface for easy registration
6. **Data Integrity**: Proper relationships between members and dependents

## Future Enhancements
- ID card generation for dependents
- Family-specific event registrations
- Family payment tracking
- Dependent-specific notifications
- Family membership renewal reminders 