# KSO Chandigarh Enhanced CSS & JavaScript Framework
## Comprehensive Documentation

### Overview
The KSO Chandigarh Enhanced CSS & JavaScript Framework provides a comprehensive set of modern, branded UI components and utilities specifically designed for the KSO Chandigarh Management System. This framework enhances the existing AdminLTE foundation with KSO-specific branding, improved user experience, and modern web standards.

### Version Information
- **Version**: 1.0.0
- **Author**: KSO Chandigarh Development Team
- **License**: MIT License
- **Built on**: AdminLTE v4.0.0
- **Compatibility**: Modern browsers (Chrome 90+, Firefox 88+, Safari 14+, Edge 90+)

---

## File Structure

### CSS Framework
- **File**: `frontend/assets/css/kso-chandigarh.css`
- **Size**: ~95KB (minified)
- **Dependencies**: AdminLTE v4.0.0, Bootstrap Icons

### JavaScript Framework
- **File**: `frontend/assets/js/kso-chandigarh.js`
- **Size**: ~45KB (minified)
- **Dependencies**: Modern ES6+ browser support

### Demo Page
- **File**: `frontend/pages/enhanced-components-demo.html`
- **Purpose**: Demonstrates all enhanced components and features

---

## KSO Brand Guidelines

### Brand Colors
```css
/* Primary Brand Colors */
--kso-primary: #1e3a8a;          /* Deep Blue */
--kso-primary-dark: #1e40af;     /* Darker Blue */
--kso-primary-light: #3b82f6;    /* Light Blue */
--kso-secondary: #dc2626;        /* Red */
--kso-secondary-dark: #b91c1c;   /* Dark Red */
--kso-secondary-light: #ef4444;  /* Light Red */

/* Accent Colors */
--kso-success: #059669;          /* Green */
--kso-warning: #d97706;          /* Orange */
--kso-info: #0891b2;             /* Cyan */
--kso-danger: #dc2626;           /* Red */
```

### Typography
- **Font Family**: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif
- **Font Weights**: Light (300), Normal (400), Bold (600), Bolder (700)
- **Base Font Size**: 14px

### Spacing System
- **XS**: 0.25rem (4px)
- **SM**: 0.5rem (8px)
- **MD**: 1rem (16px)
- **LG**: 1.5rem (24px)
- **XL**: 2rem (32px)
- **XXL**: 3rem (48px)

---

## CSS Components

### 1. Enhanced Buttons
```html
<!-- Standard Buttons -->
<button class="kso-btn kso-btn-primary">Primary Button</button>
<button class="kso-btn kso-btn-secondary">Secondary Button</button>
<button class="kso-btn kso-btn-success">Success Button</button>
<button class="kso-btn kso-btn-warning">Warning Button</button>
<button class="kso-btn kso-btn-danger">Danger Button</button>

<!-- Button Sizes -->
<button class="kso-btn kso-btn-sm kso-btn-primary">Small</button>
<button class="kso-btn kso-btn-primary">Regular</button>
<button class="kso-btn kso-btn-lg kso-btn-primary">Large</button>

<!-- Button Groups -->
<div class="kso-btn-group">
    <button class="kso-btn kso-btn-primary">Button 1</button>
    <button class="kso-btn kso-btn-primary">Button 2</button>
    <button class="kso-btn kso-btn-primary">Button 3</button>
</div>
```

### 2. Enhanced Cards
```html
<div class="kso-card">
    <div class="kso-card-header">
        <h5 class="kso-card-title">Card Title</h5>
        <div class="kso-card-actions">
            <button class="kso-btn kso-btn-sm kso-btn-primary">Action</button>
        </div>
    </div>
    <div class="kso-card-body">
        <p class="kso-card-text">Card content goes here.</p>
    </div>
    <div class="kso-card-footer">
        <small class="text-muted">Footer content</small>
    </div>
</div>
```

### 3. Enhanced Forms
```html
<form class="kso-form" data-kso-validate>
    <div class="kso-form-group">
        <label class="kso-form-label" for="name">Name</label>
        <input type="text" class="kso-form-control" id="name" 
               data-kso-required data-kso-validate="min:2|max:50">
    </div>
    
    <div class="kso-form-group">
        <label class="kso-form-label" for="email">Email</label>
        <input type="email" class="kso-form-control" id="email" 
               data-kso-required data-kso-validate="email">
    </div>
    
    <div class="kso-form-group">
        <div class="kso-form-check">
            <input type="checkbox" class="kso-form-check-input" id="agree">
            <label class="kso-form-check-label" for="agree">I agree</label>
        </div>
    </div>
    
    <button type="submit" class="kso-btn kso-btn-primary">Submit</button>
</form>
```

### 4. Enhanced Data Tables
```html
<div class="kso-table-wrapper">
    <div class="kso-table-header">
        <h3 class="kso-table-title">Data Table</h3>
        <input type="text" class="kso-form-control kso-table-search" 
               placeholder="Search...">
    </div>
    
    <table class="kso-table" data-kso-table>
        <thead>
            <tr>
                <th data-sortable>Name</th>
                <th data-sortable>Email</th>
                <th data-sortable>Status</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td>John Doe</td>
                <td>john@example.com</td>
                <td><span class="kso-badge kso-badge-success">Active</span></td>
                <td>
                    <button class="kso-btn kso-btn-sm kso-btn-primary">Edit</button>
                </td>
            </tr>
        </tbody>
    </table>
</div>
```

### 5. Enhanced Badges
```html
<span class="kso-badge kso-badge-primary">Primary</span>
<span class="kso-badge kso-badge-success">Success</span>
<span class="kso-badge kso-badge-warning">Warning</span>
<span class="kso-badge kso-badge-danger">Danger</span>
<span class="kso-badge kso-badge-info">Info</span>
<span class="kso-badge kso-badge-light">Light</span>
<span class="kso-badge kso-badge-dark">Dark</span>
```

### 6. Enhanced Tabs
```html
<div data-kso-tab-group>
    <div class="kso-nav-tabs">
        <button class="kso-nav-tab active" data-kso-tab="tab1">Tab 1</button>
        <button class="kso-nav-tab" data-kso-tab="tab2">Tab 2</button>
        <button class="kso-nav-tab" data-kso-tab="tab3">Tab 3</button>
    </div>
    
    <div id="tab1" class="kso-tab-content active">
        <p>Content for tab 1</p>
    </div>
    
    <div id="tab2" class="kso-tab-content">
        <p>Content for tab 2</p>
    </div>
    
    <div id="tab3" class="kso-tab-content">
        <p>Content for tab 3</p>
    </div>
</div>
```

### 7. Enhanced Modals
```html
<!-- Modal Trigger -->
<button class="kso-btn kso-btn-primary" data-kso-modal="exampleModal">
    Open Modal
</button>

<!-- Modal -->
<div id="exampleModal" class="kso-modal">
    <div class="kso-modal-dialog">
        <div class="kso-modal-header">
            <h5 class="kso-modal-title">Modal Title</h5>
            <button class="kso-modal-close" onclick="KSO.ui.closeModal('exampleModal')">×</button>
        </div>
        <div class="kso-modal-body">
            <p>Modal content goes here.</p>
        </div>
        <div class="kso-modal-footer">
            <button class="kso-btn kso-btn-secondary" onclick="KSO.ui.closeModal('exampleModal')">Close</button>
            <button class="kso-btn kso-btn-primary">Save</button>
        </div>
    </div>
</div>
```

---

## JavaScript Components

### 1. Notification System
```javascript
// Show notifications
KSO.notifications.success('Operation completed successfully!');
KSO.notifications.error('An error occurred.');
KSO.notifications.warning('Please check your input.');
KSO.notifications.info('Information updated.');

// Custom notification
KSO.notifications.show('Custom message', 'info', 5000, {
    // Additional options
});
```

### 2. Loading System
```javascript
// Show loading overlay
const loaderId = KSO.loading.show('Loading data...');

// Show loading on specific element
const loaderId = KSO.loading.show('Processing...', '#targetElement');

// Hide loading
KSO.loading.hide(loaderId);
```

### 3. Form Validation
```javascript
// Automatic validation with data attributes
<form data-kso-validate>
    <input type="text" data-kso-required data-kso-validate="min:2|max:50">
    <input type="email" data-kso-required data-kso-validate="email">
    <input type="tel" data-kso-required data-kso-validate="phone">
</form>

// Manual validation
const isValid = KSO.forms.validateForm(formElement);
```

### 4. Utility Functions
```javascript
// Format date
const formatted = KSO.utils.formatDate(new Date(), 'long');

// Format currency
const amount = KSO.utils.formatCurrency(1000, 'INR');

// Validate email
const isValid = KSO.utils.validateEmail('user@example.com');

// Copy to clipboard
KSO.utils.copyToClipboard('Text to copy');

// Debounce function
const debouncedFn = KSO.utils.debounce(myFunction, 300);
```

### 5. UI Interactions
```javascript
// Open modal
KSO.ui.openModal('modalId');

// Close modal
KSO.ui.closeModal('modalId');

// Show tab
KSO.ui.showTab('tabId', tabTriggerElement);

// Toggle accordion
KSO.ui.toggleAccordion('contentId', triggerElement);
```

---

## Utility Classes

### Display
```css
.kso-d-none          /* display: none */
.kso-d-block         /* display: block */
.kso-d-flex          /* display: flex */
.kso-d-grid          /* display: grid */
```

### Flex
```css
.kso-flex-1          /* flex: 1 1 0% */
.kso-flex-auto       /* flex: 1 1 auto */
.kso-align-items-center    /* align-items: center */
.kso-justify-content-between  /* justify-content: space-between */
```

### Text
```css
.kso-text-left       /* text-align: left */
.kso-text-center     /* text-align: center */
.kso-text-right      /* text-align: right */
.kso-text-primary    /* color: var(--kso-primary) */
.kso-text-success    /* color: var(--kso-success) */
```

### Spacing
```css
.kso-m-0 to .kso-m-5    /* margin utilities */
.kso-p-0 to .kso-p-5    /* padding utilities */
.kso-mt-0 to .kso-mt-5  /* margin-top utilities */
.kso-mb-0 to .kso-mb-5  /* margin-bottom utilities */
.kso-ml-0 to .kso-ml-5  /* margin-left utilities */
.kso-mr-0 to .kso-mr-5  /* margin-right utilities */
```

### Background
```css
.kso-bg-primary      /* background: var(--kso-primary) */
.kso-bg-success      /* background: var(--kso-success) */
.kso-bg-warning      /* background: var(--kso-warning) */
.kso-bg-danger       /* background: var(--kso-danger) */
```

### Border
```css
.kso-border          /* border: 1px solid #e5e7eb */
.kso-border-primary  /* border-color: var(--kso-primary) */
.kso-rounded         /* border-radius: var(--kso-radius-md) */
.kso-rounded-lg      /* border-radius: var(--kso-radius-lg) */
```

### Shadow
```css
.kso-shadow-sm       /* box-shadow: var(--kso-shadow-sm) */
.kso-shadow-md       /* box-shadow: var(--kso-shadow-md) */
.kso-shadow-lg       /* box-shadow: var(--kso-shadow-lg) */
```

---

## Grid System

### Basic Grid
```html
<div class="kso-grid kso-grid-cols-2 kso-gap-md">
    <div class="kso-grid-item">Item 1</div>
    <div class="kso-grid-item">Item 2</div>
</div>
```

### Responsive Grid
```html
<div class="kso-grid kso-grid-cols-1 kso-grid-md-cols-2 kso-grid-lg-cols-3 kso-gap-lg">
    <div class="kso-grid-item">Item 1</div>
    <div class="kso-grid-item">Item 2</div>
    <div class="kso-grid-item">Item 3</div>
</div>
```

---

## Form Validation Rules

### Available Rules
- `required`: Field is required
- `email`: Valid email format
- `phone`: Valid Indian phone number
- `min:n`: Minimum n characters
- `max:n`: Maximum n characters
- `number`: Must be a number

### Usage
```html
<input type="text" data-kso-validate="required|min:2|max:50">
<input type="email" data-kso-validate="required|email">
<input type="tel" data-kso-validate="required|phone">
```

---

## Accessibility Features

### Screen Reader Support
```css
.kso-sr-only    /* Screen reader only content */
```

### High Contrast Mode
- Automatic detection and adaptation
- Enhanced border widths
- Improved focus indicators

### Keyboard Navigation
- Tab navigation support
- Focus management
- Escape key handling for modals

### Reduced Motion
- Automatic detection of `prefers-reduced-motion`
- Disabled animations for sensitive users

---

## Browser Support

### Modern Browsers
- Chrome 90+
- Firefox 88+
- Safari 14+
- Edge 90+

### Features Used
- CSS Custom Properties (Variables)
- CSS Grid and Flexbox
- ES6+ JavaScript
- Fetch API
- Clipboard API

---

## Performance Optimization

### CSS Optimization
- Minified production version
- Efficient selector usage
- Minimal reflow/repaint operations

### JavaScript Optimization
- Lazy loading components
- Debounced event handlers
- Minimal DOM manipulation

### Best Practices
- Progressive enhancement
- Graceful degradation
- Efficient animations
- Optimized images

---

## Customization

### CSS Variables
Override any CSS variable to customize the theme:
```css
:root {
    --kso-primary: #your-color;
    --kso-font-family: 'Your Font';
}
```

### JavaScript Configuration
```javascript
// Override default configuration
KSO.config.animationDuration = 500;
KSO.config.sessionTimeout = 60;
KSO.config.debugMode = true;
```

---

## Migration Guide

### From Previous Version
1. Replace old CSS file with `kso-chandigarh.css`
2. Include `kso-chandigarh.js` after AdminLTE
3. Update HTML classes to use `kso-` prefixes
4. Test all functionality thoroughly

### Class Mapping
```css
/* Old */                    /* New */
.btn-primary         →       .kso-btn.kso-btn-primary
.card               →       .kso-card
.form-control       →       .kso-form-control
.table              →       .kso-table
```

---

## Troubleshooting

### Common Issues

#### CSS Not Loading
- Check file path is correct
- Verify file permissions
- Check browser console for errors

#### JavaScript Not Working
- Ensure proper load order (AdminLTE first)
- Check browser console for errors
- Verify browser compatibility

#### Styling Conflicts
- Use more specific CSS selectors
- Check for duplicate class names
- Use `!important` sparingly

### Debug Mode
```javascript
// Enable debug mode
KSO.config.debugMode = true;

// Check initialization
document.addEventListener('kso:init', (e) => {
    console.log('KSO initialized:', e.detail);
});
```

---

## Contributing

### Development Setup
1. Clone the repository
2. Install dependencies
3. Run development server
4. Make changes and test
5. Submit pull request

### Code Standards
- Follow existing code style
- Add comments for complex logic
- Test across supported browsers
- Update documentation

### Reporting Issues
- Use GitHub issues
- Provide clear reproduction steps
- Include browser/version information
- Add relevant screenshots

---

## License

MIT License - See LICENSE file for details.

---

## Support

For support and questions:
- Documentation: This file
- Issues: GitHub Issues
- Email: development@kso-chandigarh.org

---

## Changelog

### Version 1.0.0 (2024-12-19)
- Initial release
- Complete CSS framework with KSO branding
- JavaScript utilities and components
- Form validation system
- Notification system
- Loading states
- Modal system
- Enhanced tables
- Accessibility features
- Responsive design
- Print optimization
