# phpMyAdmin Installation Guide for KSO Chandigarh

## Option 1: Install XAMPP (Recommended)

### Step 1: Download XAMPP
1. Go to https://www.apachefriends.org/download.html
2. Download XAMPP for Windows (latest version with PHP 8.x)
3. Run the installer as Administrator

### Step 2: Install XAMPP
1. Choose installation directory (default: C:\xampp)
2. Select components:
   - Apache ✓
   - MySQL ✓ 
   - PHP ✓
   - phpMyAdmin ✓
3. Complete installation

### Step 3: Start Services
1. Open XAMPP Control Panel
2. Start "Apache" service
3. Start "MySQL" service (optional if using remote database)

### Step 4: Access phpMyAdmin
1. Open browser and go to: http://localhost/phpmyadmin
2. Default login: username "root", no password

## Option 2: Standalone phpMyAdmin Installation

### Step 1: Download phpMyAdmin
1. Go to https://www.phpmyadmin.net/downloads/
2. Download the latest version (ZIP file)
3. Extract to a folder (e.g., C:\phpmyadmin)

### Step 2: Install PHP (if not already installed)
1. Download PHP from https://windows.php.net/download/
2. Extract to C:\php
3. Add C:\php to your system PATH

### Step 3: Configure phpMyAdmin
1. Copy config.sample.inc.php to config.inc.php
2. Edit config.inc.php with your database settings

## Configuration for KSO Chandigarh Database

### Database Connection Settings:
```php
$cfg['Servers'][$i]['host'] = 'localhost';  // or your remote host
$cfg['Servers'][$i]['user'] = 'ktxmmosu_kso_db';
$cfg['Servers'][$i]['password'] = 'KSO@2025';
$cfg['Servers'][$i]['auth_type'] = 'config';
```

### Security Settings:
```php
$cfg['blowfish_secret'] = 'your-32-character-secret-key';
$cfg['ForceSSL'] = true;  // for production
```

## Next Steps After Installation

1. **Test Connection**: Access phpMyAdmin and verify database connection
2. **Create Admin User**: Set up a secure admin user instead of root
3. **Import Database**: If you have SQL dumps, import them
4. **Configure Security**: Set proper passwords and access controls

## Troubleshooting

### Common Issues:
- **Port 80 in use**: Change Apache port in XAMPP config
- **MySQL connection failed**: Check database credentials
- **Access denied**: Verify user permissions

### Alternative Tools:
- **HeidiSQL**: Lightweight database client
- **MySQL Workbench**: Official MySQL GUI
- **DBeaver**: Universal database tool

## Integration with KSO System

Once phpMyAdmin is installed, you can:
1. View and edit the KSO Chandigarh database
2. Create new admin users
3. Backup and restore data
4. Monitor database performance
5. Run SQL queries directly

Would you like me to help with any specific part of the installation?
