# KSO Chandigarh Deployment Guide for Razorhost Starter Plan

This guide will help you deploy the KSO Chandigarh Management System on Razorhost's Starter Plan. Follow these steps to ensure a smooth deployment process.

## Pre-Deployment Checklist

1. **Prepare Your Hosting Account**
   - Ensure you have access to your Razorhost control panel
   - Note your MySQL database name, username, and password
   - Verify PHP version (minimum PHP 7.4 required, PHP 8.0+ recommended)

2. **Prepare Your Project Files**
   - Update the configuration in `api/config.php` with your Razorhost database credentials
   - Set `$is_production = true` in `api/config.php` for production environment

## Deployment Steps

### 1. Configure Your Project for Razorhost

Before uploading, make these changes to `api/config.php`:

```php
// In api/config.php, update these values:
$is_production = true;

$db_config = [
    'host' => 'localhost',
    'dbname' => 'razorhos_kso_chandigarh',  // Your actual database name
    'username' => 'razorhos_kso_user',      // Your actual database username
    'password' => 'your_database_password', // Your actual database password
    'charset' => 'utf8mb4'
];
```

### 2. Upload Files

Upload all files to your hosting account using one of these methods:

- **FTP/SFTP**: Upload all files to your public_html directory
- **Control Panel File Manager**: Upload a ZIP archive and extract it

Important: Make sure to maintain the directory structure.

### 3. Database Setup

1. Access phpMyAdmin through your Razorhost control panel
2. Create a new database if not already created by your host
3. Import the database using the SQL file: `ktxmmosu_kso_chandigarh.sql`

### 4. File Permissions

Set the correct permissions for these directories:

```
uploads/     - 755 (or 775)
storage/     - 755 (or 775)
logs/        - 755 (or 775)
```

Ensure files inside these directories are 644.

### 5. Test Your Deployment

1. Visit your website URL to ensure the main page loads
2. Test the login functionality at: `yourdomain.com/login.html`
3. Test the API at: `yourdomain.com/api/status/check.php`

## Troubleshooting Common Issues

### Database Connection Errors

If you see "Database connection failed" messages:

1. Verify database credentials in `api/config.php`
2. Check if your database name has a prefix (often your hosting username)
3. Ensure your database user has the correct permissions

### File Upload Issues

If file uploads don't work:

1. Check permissions on the uploads directory
2. Verify PHP settings: `upload_max_filesize` and `post_max_size`
3. Ensure .htaccess is properly uploaded and not being overridden

### 500 Internal Server Errors

If you're seeing 500 errors:

1. Check your hosting error logs
2. Verify PHP version compatibility
3. Check .htaccess syntax for compatibility with your hosting

## Razorhost-Specific Optimizations

### PHP Configuration

Razorhost Starter Plan typically limits PHP resources. Optimize by:

1. Enabling opcache in php.ini (if available)
2. Setting appropriate memory limits
3. Enabling GZIP compression via .htaccess

### Database Optimizations

1. Keep database queries efficient
2. Use indexed fields for searches
3. Implement caching where possible

## Maintenance

### Regular Backups

Even though Razorhost may provide backups, set up your own backup routine:

1. Export database regularly through phpMyAdmin
2. Download updated files periodically
3. Store backups in multiple secure locations

### Updates

When updating your application:

1. Always backup before updating
2. Test updates locally first
3. Upload only changed files when possible

## Support

If you encounter issues with your Razorhost deployment:

1. Contact Razorhost support for hosting-specific issues
2. Check your project documentation for application-specific questions
3. Review logs in the `logs/` directory for detailed error information

---

This deployment guide is specifically tailored for KSO Chandigarh deployment on Razorhost's Starter Plan. Adjust as needed based on your specific hosting account details.
